/*
 * Test of Petsc functionality: solve with user-supplied stopping test
 */
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "petsc.h"
#include "mpi.h"
#include "parallel_auxs.h"
#include "matrix_auxs.h"
#include "netsolve_petsc.h"
#include "petsc_auxs.h"

extern int user_test(double anorm,double rnorm,double r0norm,double bnorm,
		     double xnorm,double epsr,double epsa,double epsd,
		     int it,int maxit,
		     int *outcome);

int main(int Argc,char **Args)
{
#include "../test/declarations.c"
  iterative_info_block info; double rtol; int maxit;

#include "../test/setup.c"
  if (mytid==0) {
    printf("Relative tolerance : "); scanf("%lf",&rtol); printf("\n");
    printf("Maximum #iterations : "); scanf("%d",&maxit); printf("\n");
  }

  ierr = petsc_allocate_info_block(comm,&info); ERR_RETURN(ierr);
  ierr = iterative_set_params(info,rtol,maxit); ERR_RETURN(ierr);
  ierr = petsc_params
    ((petsc_info_block)info,1.e-12,1.e+6,&user_test); ERR_RETURN(ierr);

  ierr = petsc_iterative_driver
    (Argc,Args, MPI_COMM_WORLD, first,local_size,
     values,indices,pointers,
     rhs_vector,sol_vector,
     info); ERR_RETURN(ierr);
  ierr = iterative_get_return_params(info,&conv,&its); ERR_RETURN(ierr);
  if (mytid==0) {
    if (conv) {
      printf("The method converged in %d iterations\n",its);
    } else {
      printf("No convergence in the number of iterations specified\n");
    }
  }

#include "../test/unset.c"
  free(info);

  return 0;
}
