#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "petsc.h"
#include "netsolve_petsc.h"

int main(int Argc,char **Args)
{
  int       size = 4,nnzero,i,j,IJ;
  int       *idx,*jdx;
  int       ierr;
  double *mv,*xv,*yv;

  nnzero = size*size;

  /* allocate */
  idx = (int *) malloc(nnzero*sizeof(int));
  jdx = (int *) malloc(nnzero*sizeof(int));
  mv = (double *) malloc(nnzero*sizeof(double));
  xv = (double *) malloc(size*sizeof(double));
  yv = (double *) malloc(size*sizeof(double));

  /* fill in matrix */
  IJ = 0;
  for (i=0; i<size; i++) {
    xv[i] = 1.;
    for (j=0; j<size; j++) {
      idx[IJ] = i; jdx[IJ] = j;
      if (i==j) {
	mv[IJ] = size+1.;
      } else {
	mv[IJ] = -1.;
      }
      IJ++;
    }
  }

  PetscInitialize(&Argc,&Args,PETSC_NULL,PETSC_NULL);
  ierr = petsc_sparse_direct_solve(MPI_COMM_WORLD,
		  mv,xv,size,size,size,size,nnzero,idx,jdx,yv);
  PetscFinalize();

  printf("Return values:");
  for (i=0; i<size; i++) printf(" %e",yv[i]);
  printf("\n");

  free(mv); free(xv); free(yv);

  return 0;
}
