#include <stdio.h>
#include <math.h>
/* general Petsc includes */
#include "petsc.h"
#include "mat.h"
#include "is.h"
/* specific include for this test */
#include "netsolve_petsc.h"

int petsc_sparse_direct_solve(MPI_Comm comm,
	     double *mv,double *xv,int m,int n,int M,int N,
	     int nz,int *idx,int *jdx,
	     double *yv)
{
  Mat       A;
  Vec       X,V;
  IS        row,col;
  int       ierr;
  int       i;

  ierr = PetscSplitOwnership(comm,&m,&M); ERR_RETURN(ierr);
  ierr = PetscSplitOwnership(comm,&n,&N); ERR_RETURN(ierr);
  ierr = MatCreate(comm,M,N,&A); ERR_RETURN(ierr);
  ierr = VecCreateMPIWithArray(comm,n,PETSC_DECIDE,xv,&X); ERR_RETURN(ierr);
  ierr = VecCreateMPIWithArray(comm,m,PETSC_DECIDE,yv,&V); ERR_RETURN(ierr);

  for (i=0; i<nz; i++) {
    ierr = MatSetValues(A,1,idx+i,1,jdx+i,mv+i,INSERT_VALUES);
    ERR_RETURN(ierr);
  }
  ierr = MatAssemblyBegin(A,MAT_FINAL_ASSEMBLY); ERR_RETURN(ierr);
  ierr = MatAssemblyEnd(A,MAT_FINAL_ASSEMBLY); ERR_RETURN(ierr);

  {
    MatOrderingType o_type = ORDER_NATURAL;
    
    /*
    ierr = MatGetReorderingTypeFromOptions(PETSC_NULL,&o_type);
    ERR_RETURN(ierr);
    */
    ierr = MatGetOrdering(A,o_type,&row,&col); ERR_RETURN(ierr);
    ierr = MatLUFactor(A,row,col,2.0); ERR_RETURN(ierr);
  }
  ierr = MatSolve(A,X,V); ERR_RETURN(ierr);
  ierr = ISDestroy(row); ERR_RETURN(ierr);
  ierr = ISDestroy(col); ERR_RETURN(ierr);

  ierr = MatDestroy(A); ERR_RETURN(ierr);
  ierr = VecDestroy(X); ERR_RETURN(ierr);
  ierr = VecDestroy(V); ERR_RETURN(ierr);

  return 0;
}
