#include <stdio.h>
#include <math.h>
/* general Petsc includes */
#include "petsc.h"
#include "mpi.h"
#include "mat.h"
#include "netsolve_petsc.h"
#include "petsc_auxs.h"

int petsc_matprod(MPI_Comm comm,
	    double *mv,double *xv,int m,int nz,
	    int *idx,int *pointers,
	    double *yv)
{
  Mat       A;
  Vec       X,V;
  int       ierr;

  ierr = VecCreateMPIWithArray(comm,m,PETSC_DECIDE,xv,&X); ERR_RETURN(ierr);
  ierr = VecCreateMPIWithArray(comm,m,PETSC_DECIDE,yv,&V); ERR_RETURN(ierr);

  ierr = petsc_matrix_from_crs(comm,m,mv,idx,pointers,&A); ERR_RETURN(ierr);

  ierr = MatMult(A,X,V); ERR_RETURN(ierr);

  ierr = MatDestroy(A); ERR_RETURN(ierr);
  ierr = VecDestroy(X); ERR_RETURN(ierr);
  ierr = VecDestroy(V); ERR_RETURN(ierr);

  return 0;
}
