#ifndef NETSOLVE_PETSC_H
#define NETSOLVE_PETSC_H 1

#include "driver/iterative.h"
#include "mpi.h"

typedef struct petsc_info_block_ *petsc_info_block;

/*
 * driver and computational routines for interfacing petsc to netsolve
 */

/* Iterative matrix solution */
extern int petsc_iterative_driver
(int Argc,char **Args, MPI_Comm comm,
 int first,int local_size,
 double *values,int *indices,int *pointers,
 double *rhs_vector,double *solution_vector,
 iterative_info_block info);

/* Matrix times vector product */
extern int petsc_matprod
(MPI_Comm comm,
 double *mat_el,double *x_el,
 int local,int nnzero,
 int *idx,int *pointers,
 double *return_vec_el
 );

/* Direct matrix solution */
extern int petsc_sparse_direct_solve
(MPI_Comm comm,
 double *mat_el,double *x_el,
 int isize,int jsize,int Isize,int Jsize,int nnzero,
 int *idx,int *pointers,
 double *return_vec_el
 );

#endif
