ierr = PetscInitialize(&Argc,&Args,0,0); ERR_ABORT(ierr);
comm = MPI_COMM_WORLD;
ierr = MPI_Comm_size(comm,&ntids); ERR_ABORT(ierr);
ierr = MPI_Comm_rank(comm,&mytid); ERR_ABORT(ierr);

if (mytid==0) {
  printf("1=utah1, 2=utah2, >2=5pt Laplace: "); scanf("%d",&domain_size);}
MPI_Bcast(&domain_size,1,MPI_INT,0,comm);

if (domain_size<=2) {
  if (domain_size==1) {
    PetscPrintf(comm,"Utah matrix 1\n");
    ierr = read_utah_mat
      (comm,"/home/eijkhout/Projects/utah/data/mat1","/home/eijkhout/Projects/utah/data/rhs1",100,
       &first,&last,&nnzeros,&total_size,&pointers,&indices,&values,
       &rhs_vector); CHKERRA(ierr);
  } else if (domain_size==2) {
    PetscPrintf(comm,"Utah matrix 2\n");
    ierr = read_utah_mat
      (comm,"/home/eijkhout/Projects/utah/data/mat2","/home/eijkhout/Projects/utah/data/rhs2",100,
       &first,&last,&nnzeros,&total_size,&pointers,&indices,&values,
       &rhs_vector); CHKERRA(ierr);
  }
  local_size = last-first;
  ALLOCATE(sol_vector,local_size,double,"solution");
  ALLOCATE(tmp_vector,local_size,double,"temporary");
} else {
  PetscPrintf(comm,"Laplace matrix of h-1=%d\n",domain_size);
  total_size = domain_size * domain_size;

  ierr = divide(comm,total_size,&first,&last); ERR_ABORT(ierr);
  if (ierr) printf("Error in vector divide routine\n");
  local_size = last-first;
  
  ierr = construct_crs_system
    (&values,&indices,&pointers,&nnzeros,
     first,local_size,domain_size,total_size); ERR_RETURN(ierr);
  ierr = construct_crs_vectors
    (first,local_size,domain_size,total_size,
     &sol_vector,&rhs_vector,&tmp_vector); ERR_RETURN(ierr);
}

#ifdef DEBUG
  ierr = print_crs_matrix(values,indices,pointers,0,first,local_size);
  if (ierr) {
    printf("error in print_crs_matrix\n"); return 1;}
#endif
