#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "mpi.h"
#include "ma28.h"
#include "./netsolve_ma28.h"
#include "./ma28_impl.h"
#include "matrix_auxs.h"
#include "parallel_auxs.h"
#include "driver/direct.h"

int ma28_params(direct_info_block *info,double pivot)
{
  ma28_info_block ma28_info;

  ma28_info = (ma28_info_block) malloc
    (sizeof(struct ma28_info_block_));
  ma28_info->pivot = pivot;
  *info = (direct_info_block) ma28_info;

  return 0;
}

int ma28_driver
(MPI_Comm comm, double *values,int *indices,int *pointers,int order,
 direct_info_block info,
 double *rhs_vector,double *sol_vector)
{
  ma28_info_block ma28_info = (ma28_info_block) info;
  int nnz,ierr;

  {
    int flg;
    ierr = single_proc(comm,&flg); ERR_RETURN(ierr);
    if (!flg) {
      printf("ma28 can only run on a single processor.\n"); return 1;}
  }

  ierr = crs_nnzeros(pointers,order,0,&nnz); ERR_RETURN(ierr);

  ierr = crs_mat_tobase1(values,indices,pointers,order); ERR_RETURN(ierr);
#ifdef DEBUG
  ierr = print_crs_matrix(values,indices,pointers,1,0,order); ERR_RETURN(ierr);
#endif
  memcpy(sol_vector,rhs_vector,order*sizeof(double));

  {
    double *ma28_values=0; int *ma28_indices=0,*ma28_pointers=0;
    double *rwork1n; int *iwork5n,*iwork8n;
    int n_col_idx,n_row_idx,*o_row_idx,*col_idx,*row_idx;
    double pivot = ma28_info->pivot; int type=1;
    int err_info;
    
    rwork1n = (double*) malloc(order*sizeof(double));
    iwork5n = (int*) malloc(5*order*sizeof(int));
    iwork8n = (int*) malloc(8*order*sizeof(int));
    n_col_idx = nnz ; n_row_idx = nnz;
    o_row_idx = (int*) malloc(n_row_idx*sizeof(int));
    {
      int i,j;
      for (i=0; i<order; i++)
	for (j=pointers[i]; j<pointers[i+1]; j++)
	  o_row_idx[j-1] = i+1;
    }
  again:
    if (ma28_values) {
      free(ma28_values); free(ma28_indices); free(ma28_pointers);}

    ma28_values = (double*) malloc(n_col_idx*sizeof(double));
    col_idx = (int*) malloc(n_col_idx*sizeof(int));
    row_idx = (int*) malloc(n_row_idx*sizeof(int));
    memcpy(ma28_values,values,nnz*sizeof(double));
    memcpy(col_idx,indices,nnz*sizeof(int));
    memcpy(row_idx,o_row_idx,nnz*sizeof(int));

    ma28ad
      (&order,&nnz,ma28_values,
       &n_col_idx,row_idx,&n_row_idx,col_idx,
       &pivot,
       iwork5n,iwork8n,rwork1n,&ierr,&err_info);
    
#ifdef TRACE
    fprintf(stderr,"MA28 return code %d,%d\n",ierr,err_info);
#endif
    if (ierr<0) {
      ierr = -ierr;
      if (0) {
      } else if (ierr>=8 && ierr<=12) {
	fprintf(stdout,"Error %d in input parameters\n",ierr);
	return 1;
      } else if (ierr==14) {
#ifdef TRACE
	fprintf(stderr,"Error of duplicate elements; ignore it for now.\n");
#endif
      } else if (ierr==23) {
	if (err_info>0) {
#ifdef TRACE
	  fprintf(stderr,"Increase col space by 2*%d\n",err_info);
#endif
	  n_col_idx += 2*err_info; goto again;
	} else {
	  fprintf(stdout,"Unknown error %d in mc23ad\n",err_info); return 1;
	}
      } else if (ierr>30) {
	ierr -= 30;
#ifdef TRACE
	fprintf(stderr,"Error %d occurred in ma30ad\n",ierr);
#endif
	if (ierr<3) {
	  fprintf(stdout,"Matrix is singular. I give up.\n"); return 1;
	} else if (ierr==3) {
	  n_row_idx = err_info+order;
#ifdef TRACE
	  fprintf(stderr,"Increasing row index space to %d.\n",err_info);
#endif
	  goto again;
	} else if (ierr==4) {
#ifdef TRACE
	  fprintf(stderr,"Not enough col index space; doubling.\n");
#endif
	  n_col_idx *= 2; goto again;
	} else if (ierr==5) {
	  n_col_idx = err_info+order;
#ifdef TRACE
	  fprintf(stderr,"Not enough col index space; setting to %d\n",n_col_idx);
#endif
	  goto again;
	} else if (ierr==6) {
	  n_col_idx = err_info+order; n_row_idx *= 2;
#ifdef TRACE
	  fprintf(stderr,"Not enough col index space: setting to %d; also doubling row space.\n",n_col_idx);
#endif
	  goto again;
	} else {
	  fprintf(stdout,"Unknown ma31ad error: %d\n",ierr);
	  return 1;
	}
      }
    }

    free(iwork8n);
    ma28cd
      (&order,ma28_values,&n_col_idx,col_idx,
       iwork5n,sol_vector,rwork1n,&type);

    free(ma28_values); free(ma28_indices); free(ma28_pointers);
    free(iwork5n); free(rwork1n);
  }
  
  ierr = crs_mat_tobase0(values,indices,pointers,order); ERR_RETURN(ierr);
#ifdef DEBUG
  ierr = print_crs_matrix
    (values,indices,pointers,0,0,order); ERR_RETURN(ierr);
#endif

  return 0;
}
