/*
 * tester for the Itpack iterative solver
 */
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "mpi.h"
#include "sparse_globals.h"
/* general Itpack includes */
#include "itpack.h"
/* specific include for this test */
#include "parallel_auxs.h"
#include "matrix_auxs.h"
#include "netsolve_itpack.h"
#include "itpack_auxs.h"

int main(int Argc,char **Args)
{
#include "../test/declarations.c"
  iterative_info_block info; double rtol; int maxit;

#include "../test/setup.c"
#include "../test/iter_setup.c"

  ierr = itpack_allocate_info_block(comm,&info); ERR_RETURN(ierr);
  ierr = iterative_set_params(info,rtol,maxit); ERR_RETURN(ierr);

#ifdef JCG
  if (mytid==0) printf("\nUsing JCG driver\n\n");
  ierr = itpack_jcg_driver
    (MPI_COMM_WORLD,
     values,indices,pointers, first,local_size,
     rhs_vector,sol_vector, rtol,maxit,
     &info); ERR_RETURN(ierr);
#else
#ifdef JSI
  if (mytid==0) printf("\nUsing JSI driver\n\n");
  ierr = itpack_jsi_driver
    (MPI_COMM_WORLD,
     values,indices,pointers, first,local_size,
     rhs_vector,sol_vector, rtol,maxit,
     &info); ERR_RETURN(ierr);
#else
#ifdef SSORCG
  if (mytid==0) printf("\nUsing SSOR-CG driver\n\n");
  ierr = itpack_ssorcg_driver
    (MPI_COMM_WORLD,
     values,indices,pointers, first,local_size,
     rhs_vector,sol_vector, rtol,maxit,
     &info); ERR_RETURN(ierr);
#else
#ifdef SSORSI
  if (mytid==0) printf("\nUsing SSOR-SI driver\n\n");
  ierr = itpack_ssorsi_driver
    (MPI_COMM_WORLD,
     values,indices,pointers, first,local_size,
     rhs_vector,sol_vector, rtol,maxit,
     &info); ERR_RETURN(ierr);
#else
#ifdef RSCG
  if (mytid==0) printf("\nUsing RSCG driver\n\n");
  ierr = itpack_rscg_driver
    (MPI_COMM_WORLD,
     values,indices,pointers, first,local_size,
     rhs_vector,sol_vector, rtol,maxit,
     &info); ERR_RETURN(ierr);
#else
#ifdef RSSI
  if (mytid==0) printf("\nUsing RSSI driver\n\n");
  ierr = itpack_rssi_driver
    (MPI_COMM_WORLD,
     values,indices,pointers, first,local_size,
     rhs_vector,sol_vector, rtol,maxit,
     &info); ERR_RETURN(ierr);
#else
  if (mytid==0) printf("\nUsing general driver\n\n");
  ierr = itpack_params
    ((itpack_info_block)info,NetsolveChebychev,NetsolveSSOR); ERR_RETURN(ierr);

  ierr = itpack_iterative_driver
    (MPI_COMM_WORLD,
     values,indices,pointers, first,local_size,
     rhs_vector,sol_vector,
     info); ERR_RETURN(ierr);
#endif
#endif
#endif
#endif
#endif
#endif

  ierr = iterative_get_return_params(info,&conv,&its); ERR_RETURN(ierr);
  if (mytid==0) {
    if (conv) {
      printf("The method converged in %d iterations\n",its);
    } else {
      printf("No convergence in the number of iterations specified\n");
    }
  }
#include "../test/unset.c"
  free(info);

  return 0;
}
