#ifndef NETSOLVE_ITPACK_H
#define NETSOLVE_ITPACK_H 1

#include "driver/iterative.h"
#include "mpi.h"

typedef struct itpack_info_block_ *itpack_info_block;

/*
 * driver and computational routines for interfacing itpack to netsolve
 */

/*
 * Iterative matrix solution
 */
extern int itpack_iterative_driver
(MPI_Comm comm,
 double *values,int *indices,int *pointers,
 int first,int local_size,
 double *rhs_vector,double *sol_vector,
 iterative_info_block info);

/* special purpose drivers */
extern int itpack_jcg_driver
(MPI_Comm comm,
 double *values,int *indices,int *pointers,
 int first,int local_size,
 double *rhs_vector,double *sol_vector,
 double rtol, int maxit, iterative_info_block info);
extern int itpack_jsi_driver
(MPI_Comm comm,
 double *values,int *indices,int *pointers,
 int first,int local_size,
 double *rhs_vector,double *sol_vector,
 double rtol, int maxit, iterative_info_block info);
extern int itpack_ssorcg_driver
(MPI_Comm comm,
 double *values,int *indices,int *pointers,
 int first,int local_size,
 double *rhs_vector,double *sol_vector,
 double rtol, int maxit, iterative_info_block info);
extern int itpack_ssorsi_driver
(MPI_Comm comm,
 double *values,int *indices,int *pointers,
 int first,int local_size,
 double *rhs_vector,double *sol_vector,
 double rtol, int maxit, iterative_info_block info);
extern int itpack_rscg_driver
(MPI_Comm comm,
 double *values,int *indices,int *pointers,
 int first,int local_size,
 double *rhs_vector,double *sol_vector,
 double rtol, int maxit, iterative_info_block info);
extern int itpack_rssi_driver
(MPI_Comm comm,
 double *values,int *indices,int *pointers,
 int first,int local_size,
 double *rhs_vector,double *sol_vector,
 double rtol, int maxit, iterative_info_block info);

#endif

