#ifdef ERR_RETURN_H
#else
#define ERR_RETURN_H 1

#define ERR_ABORT(a) \
    if (a) {printf("Error in line %d of file %s.\n",__LINE__,__FILE__); \
            MPI_Abort(MPI_COMM_WORLD,1);}
#define ERR_RETURN(a) \
    if (a) {printf("Error in line %d of file %s.\n",__LINE__,__FILE__); \
            return a;}
#define ERR_REPORT(a) \
    {printf("Error in line %d of file %s:\n  %s\n",__LINE__,__FILE__,a); \
     return 1;}
#define ERR_REPORTi(a,b) \
    {printf("Error in line %d of file %s:\n  %s: %d\n", \
	    __LINE__,__FILE__,a,b); \
     return 1;}
#define ERR_REPORTii(a,b,c) \
    {printf("Error in line %d of file %s:\n  %s: %d,%d\n", \
	    __LINE__,__FILE__,a,b,c); \
     return 1;}
#define ERR_REPORTiii(a,b,c,d) \
    {printf("Error in line %d of file %s:\n  %s: %d,%d,%d\n", \
	    __LINE__,__FILE__,a,b,c,d); \
     return 1;}
#define OVERFLOW_REPORT(a,b,c,d) \
    {printf("Error in line %d of file %s:\n  %s\n  index %d outside %d-%d\n",\
            __LINE__,__FILE__,a,b,c,d); \
     return 1;}
#define ALLOC_CHK(a,b) \
    {if (!a) {printf("Error in allocating %s; line %d of file %s,\n", \
		     b,__LINE__,__FILE__); return 1;}}
#define ALLOCATE(a,b,c,d) \
    {if ((int)(b)) a = (c*) malloc((b)*sizeof(c)); \
              else a = (c*) malloc(sizeof(c)); \
     if (!a) { \
       printf("Error in allocating %s of size %d ; line %d of file %s\n", \
              d,b,__LINE__,__FILE__); return 1;} \
    }                     
#endif
