#ifndef NETSOLVE_SPARSE_H
#define NETSOLVE_SPARSE_H 1

#include "mpi.h"
#include "sparse_globals.h"

struct general_info_block_ {
  int ierr;
};
typedef struct general_info_block_* general_info_block;

typedef void *iterative_info_block;

extern int netsolve_iterative_solve
(NETSOLVE_SPARSE_PACKAGE package, int Argc,char **Args, MPI_Comm comm,
 int first,int local_size,
 int *row_indices,
 double *values,int *indices,int *pointers,
 double *rhs_vector,double *solution_vector,
 iterative_info_block info
);

typedef void *direct_info_block;

extern int netsolve_sparse_direct_solve
(NETSOLVE_SPARSE_PACKAGE package, int Argc,char **Args, MPI_Comm comm,
 int first,int local_size,int *row_numbers,
 double *values,int *indices,int *pointers,
 direct_info_block info,
 double *rhs_vector,double *solution_vector
);

#endif
