/*
 * Input parameter handling for iterative routines
 */
#include <stdlib.h>
#include <stdio.h>
#include "mpi.h"
#include "sparse_globals.h"
#include "iterative.h"
#include "iterative_impl.h"

int iterative_set_params(iterative_info_block info,double rtol,int maxit)
{
  int ierr;
  ierr = MPI_Bcast(&rtol,1,MPI_DOUBLE,0,info->comm); ERR_RETURN(ierr);
  ierr = MPI_Bcast(&maxit,1,MPI_INT,0,info->comm); ERR_RETURN(ierr);
  info->rtol = rtol; info->maxit = maxit;
  return 0;
}

int iterative_set_return_params(iterative_info_block info,int conv,int its)
{
  info->conv = conv; info->its = its;
  return 0;
}

int iterative_get_return_params(iterative_info_block info,int *conv,int *its)
{
  *conv = info->conv; *its = info->its;
  return 0;
}
