#ifndef NETSOLVE_ITERATIVE_H
#define NETSOLVE_ITERATIVE_H 1

#include "mpi.h"
#include "sparse_globals.h"

typedef struct iterative_info_block_* iterative_info_block;

extern int netsolve_iterative_solve
(NETSOLVE_SPARSE_PACKAGE package, int Argc,char **Args, MPI_Comm comm,
 int first,int local_size,
 int *row_indices,
 double *values,int *indices,int *pointers,
 double *rhs_vector,double *solution_vector,
 iterative_info_block info
);

extern int iterative_set_params(iterative_info_block info,double rtol,int maxit);
extern int iterative_set_return_params(iterative_info_block info,int conv,int its);
extern int iterative_get_return_params(iterative_info_block info,int *conv,int *its);

#endif
