#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "mpi.h"
/* general Aztec includes */
#include "az_aztec.h"
/* specific include for this test */
#include "parallel_auxs.h"
#include "matrix_auxs.h"
#include "./netsolve_aztec.h"
#include "./aztec_auxs.h"

int main(int Argc,char **Args)
{
  MPI_Comm  comm;
  int       total_size = 5,mysize,nnzero, np,Np,first,last;
  int       *idx;
  int       ierr;
  double *mv,*xv,*yv;

  ierr = MPI_Init(&Argc,&Args);
  if (ierr) printf("Error in MPI Init\n");
  comm = MPI_COMM_WORLD;
  ierr = MPI_Comm_size(comm,&Np);
  if (ierr) printf("Error in comm size\n");
  ierr = MPI_Comm_rank(comm,&np);
  if (ierr) printf("Error in comm rank\n");

  ierr = divide(comm,total_size,&first,&last);
  if (ierr) {
    printf("Error in vector divide routine\n"); return 1;
#ifdef DEBUG
  } else {
    printf("My range: %d-%d\n",first,last);
#endif
  }
  mysize = last-first;

  {
    double *mv_crs;
    int *idx_crs,*ptr_crs, nnzero_crs;
    construct_crs_system
      (comm, &mv_crs,&idx_crs,&ptr_crs,&nnzero_crs,
       first,mysize,total_size,&xv,&yv);
#ifdef DEBUG
    ierr = print_crs_matrix(mv_crs,idx_crs,ptr_crs, first,mysize);
    if (ierr) {printf("error in crs matrix\n"); return 1;}
#endif
    nnzero = nnzero_crs+1;
    mv = (double*) malloc(nnzero*sizeof(double));
    idx = (int*) malloc(nnzero*sizeof(int));
    memcpy(mv,mv_crs,nnzero_crs*sizeof(double));
    memcpy(idx,idx_crs,nnzero_crs*sizeof(int));
    ierr = crs_to_aztec(mysize,first,ptr_crs,idx,mv);
    if (ierr) {printf("error in crs-to-aztec conversion\n"); return 1;}
    free(ptr_crs); free(idx_crs); free(mv_crs);
  }
#ifdef DEBUG
  ierr = print_aztec_matrix(mv,idx,first,mysize);
  if (ierr) {printf("error in aztec matrix\n"); return 1;}
#endif
  ierr = aztec_matprod(MPI_COMM_WORLD,
		 mv,xv,first,last,nnzero,idx,yv);
  if (ierr) {printf("error in aztec matrix-vector product\n"); return 1;}
  if (np==0) printf("done prod\n");
  {
    int i;
    printf("Output:");
    for (i=0; i<mysize; i++) printf(" %e",yv[i]);
    printf("\n");
  }
  /*
  printf("mv[0]:"); for (i=0; i<nnzero+1; i++) printf(" %7.3e",mv[i]); printf("\n");
  return 0;
  */

  free(xv); free(yv);
  MPI_Finalize();

  return 0;
}
