#ifndef NETSOLVE_AZTEC_H
#define NETSOLVE_AZTEC_H 1

/*
 * driver and computational routines for interfacing aztec to netsolve
 */
#include "driver/iterative.h"
#include "mpi.h"

typedef struct aztec_info_block_ *aztec_info_block;

/* Iterative matrix solution */
extern int aztec_iterative_driver
(MPI_Comm comm,
 double *values,int *indices,int *pointers,
 int first,int local_size,
 double *rhs_vector,double *sol_vector,
 iterative_info_block info);

/* Matrix vector product */
extern int aztec_matprod
(MPI_Comm comm,
 double *mat_el,double *x_el,
 int first,int last,
 int nnzero,
 int *idx,
 double *return_vec_el
 );

#endif
