#include <stdlib.h>
#include <stdio.h>
#include "mpi.h"
#include "error_returns.h"
#include "az_aztec.h"
#include "aztec_auxs.h"
#include "aztec_impl.h"
#include "driver/iterative.h"

int aztec_allocate_info_block(MPI_Comm comm,iterative_info_block *info)
{
  aztec_info_block aztec_info;

  ALLOCATE(aztec_info,1,struct aztec_info_block_,
	    "aztec info block");
  aztec_info->comm = comm;
  *info = (iterative_info_block) aztec_info;

  return 0;
}

void aztec_get_vecsizes(int *data_org,int *insize,int *outsize)
{
  *insize = data_org[AZ_N_internal]+data_org[AZ_N_border];
  *outsize = data_org[AZ_N_internal]+data_org[AZ_N_border]
    +data_org[AZ_N_external];

  return;
}
