#include <stdlib.h>
#include <stdio.h>
#include "mpi.h"
#include "parallel_auxs.h"

int single_proc(MPI_Comm comm,int *flg)
{
  int np;
  MPI_Comm_size(comm,&np);
  *flg = (np==1);
  return 0;
}

int divide(MPI_Comm comm,int m,int *first, int *last)
{
  int *ms,r,s,i,l;

  /* determine local size, crudely */
  MPI_Comm_rank(comm,&r); MPI_Comm_size(comm,&s);
  if (r<s-1) l = m/s; else l = m-(s-1)*(m/s);
  /*printf("MPI: [%d,%d]=>%d\n",r,s,l);*/

  /* cumulative local sizes */
  ms = (int *) malloc(s*sizeof(int));
  MPI_Allgather(&l,1,MPI_INT,ms,1,MPI_INT,comm);
  /*printf("sizes: ");for(i=0;i<s;i++)printf("%d,",ms[i]);printf("\n");*/
  s = 0;
  for (i=0; i<r; i++) s=s+ms[i];
  *first = s; *last = s+ms[r];

  free(ms);
  /*printf("[%d,%d:%d]\n",r,*first,*last);*/
  return 0;
}

