/*
 * Netsolve sparse test matrix functions
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "mpi.h"
#include "matrix_auxs.h"
#include "matrix_distr_auxs.h"

int distr_matmult
(MPI_Comm comm,
 double *values,int *indices,int *pointers,
 int first,int local_size,int total_size,
 double *in,double *out)
{
  int *sizes,*offsets,ntids,ip;
  double *bigvec;
  MPI_Comm_size(comm,&ntids);
  sizes = (int*) malloc(ntids*sizeof(int));
  offsets = (int*) malloc(ntids*sizeof(int));
  bigvec = (double*) malloc(total_size*sizeof(double));
  
  MPI_Allgather(&local_size,1,MPI_INT,sizes,1,MPI_INT,comm);
  /*
  {
    int i;
    printf("local sizes: ");
    for(i=0; i<ntids; i++) printf("%d ",sizes[i]);
    printf("\n");
  }
  */
  offsets[0] = 0;
  for (ip=1; ip<ntids; ip++) offsets[ip] = offsets[ip-1]+sizes[ip-1];
  /*
  {
    int i;
    printf("offsets: ");
    for(i=0; i<ntids; i++) printf("%d ",offsets[i]);
    printf("\n");
  }
  */
  MPI_Allgatherv(in,local_size,MPI_DOUBLE,
		 bigvec,sizes,offsets,MPI_DOUBLE,comm);
#ifdef DEBUG
  {
    int i;
    printf("big vector:\n");
    for (i=0; i<total_size; i++) printf("%d: %e\n",i,bigvec[i]);
  }
#endif
  crs_matmult(values,indices,pointers,local_size,
	      bigvec,out);

  free(bigvec); free(sizes); free(offsets);
  return 0;
}

/* couple of vector routines */
int vec_norm
(MPI_Comm comm,double *u,int local_size,double *nrm)
{
  int i; double r=0.,gr;
  for (i=0; i<local_size; i++) {double t = u[i]; r += t*t;}
  MPI_Allreduce(&r,&gr,1,MPI_DOUBLE,MPI_SUM,comm);
  *nrm = sqrt(gr);
  return 0;
}
int vec_diff_norm
(MPI_Comm comm,double *u,double *v,int local_size,double *err)
{
  int i; double r=0.,gr;
  for (i=0; i<local_size; i++) {double t = u[i]-v[i]; r += t*t;}
  MPI_Allreduce(&r,&gr,1,MPI_DOUBLE,MPI_SUM,comm);
  *err = sqrt(gr);
  return 0;
}

int vec_print(MPI_Comm comm,char *txt,int first,int local_size,double *vals)
{
  int mytid,i;
  MPI_Comm_rank(comm,&mytid);
  if (mytid==0)
    printf("%s:\n",txt);
  for (i=0; i<local_size; i++)
    printf("(%d,%d)=%d: %e\n",mytid,i,local_size+i,vals[i]);
  return 1;
}
