/*
 * Netsolve sparse test matrix functions
 */
#include <stdio.h>
#include <stdlib.h>
#include "sparse_globals.h"
#include "matrix_auxs.h"

int construct_crs_system
(double **values,int **indices,int **pointers,int *nnzeros,
 int first,int local_size,int domain_size,int total_size,
 double **sol_vector,double **rhs_vector,double **tmp_vector)
{
  int IJ,ijk,i,j;

  *nnzeros = 5*total_size;

  /* allocate */
  /*  *pointers = (int *) malloc((local_size+1)*5*sizeof(int));*/
  *pointers = (int *) malloc((local_size+1)*sizeof(int));
  *indices = (int *) malloc((*nnzeros+1)*sizeof(int));
  *values = (double *) malloc((*nnzeros+1)*sizeof(double));
  *sol_vector = (double *) malloc(local_size*sizeof(double));
  *rhs_vector = (double *) malloc(local_size*sizeof(double));
  *tmp_vector = (double *) malloc(local_size*sizeof(double));

  IJ = 0; ijk = 0;
  for ( i=0; i<domain_size; i++ ) {
    for ( j=0; j<domain_size; j++ ) {
      int I,J; double v;
      if (IJ>=first && IJ<first+local_size) {
	(*rhs_vector)[IJ-first] = 1.;
	(*pointers)[IJ-first] = ijk;
	I = j + domain_size*i;
	v = -1.0;
	if ( i>0 ) {
	  J = I - domain_size;
	  (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
	}
	if ( j>0 )   {
	  J = I - 1;
	  (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
	}
	{
	  double v = 4.0;
	  (*values)[ijk] = v; (*indices)[ijk] = I; ijk++;
	}
	if ( j<domain_size-1 ) {
	  J = I + 1;
	  (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
	}
	if ( i<domain_size-1 ) {
	  J = I + domain_size;
	  (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
	}
      }
      IJ++;
    }
  }
  (*pointers)[local_size] = ijk;

  return 0;
}

int destruct_crs_system
(double *mv,int *ptr,int *idx,double *xv,double *yv,double *tmp)
{
  free(mv); free(ptr); free(idx); free(xv); free(yv); free(tmp);
  return 0;
}

int crs_mat_tobase1
(double *values,int *indices,int *pointers,int order)
{
  int i,j;
  for (i=0; i<order; i++) {
    for (j=pointers[i]; j<pointers[i+1]; j++)
      indices[j]++;
    pointers[i]++;
  }
  pointers[order]++;
  return 0;
}

int crs_mat_tobase0
(double *values,int *indices,int *pointers,int order)
{
  int i,j;
  for (i=0; i<=order; i++)
    pointers[i]--;
  for (i=0; i<order; i++)
    for (j=pointers[i]; j<pointers[i+1]; j++)
      indices[j]--;
  return 0;
}

int print_crs_matrix
(double *mv,int *idx,int *ptr, int base,int first,int local_size)
{
  int i,j,nnz,ierr;

  ierr = crs_nnzeros(ptr,local_size,base,&nnz); ERR_RETURN(ierr);
  printf("CRS matrix of base %d; shown on base 0\n  #nzeros=%d\n",
	 base,nnz);
  for (i=0; i<local_size; i++) {
    printf("row [f:%d,l:%d]=g:%d: cols",first-base,i,first+i-base);
    for (j=ptr[i]-base; j<ptr[i+1]-base; j++)
      printf(" %d=>%7.3e",idx[j]-base,mv[j]);
    printf("\n");
  }
  return 0;
}

/* this is the actual number of nonzeros; the last index is one less */
int crs_nnzeros(int *ptr,int local_size,int base,int *size)
{
  if (ptr[0]!=base) {
    printf("crs_nnzeros: bad input, ptr[0]=%d, purported local size = %d\n",
	   ptr[0],local_size);
    return 1;
  } else {
    *size = ptr[local_size]-base;
    return 0;
  }
}

int crs_matmult(double *values,int *indices,int *pointers,int local_size,
		double *in,double *out)
{
  int i,j;
  for (i=0; i<local_size; i++) {
    double r = 0;
    for (j=pointers[i]; j<pointers[i+1]; j++)
      r += values[j]*in[indices[j]];
    out[i] = r;
  }
  return 0;
}

