
      subroutine ma28bd(n, nz, a, licn, ivect, jvect, icn, ikeep, iw, w,
     * iflag)
c this subroutine factorizes a matrix of a similar sparsity
c     pattern to that previously factorized by ma28a/ad.
c the parameters are as follows ...
c n      integer  order of matrix  not altered by subroutine.
c nz     integer  number of non-zeros in input matrix  not altered
c     by subroutine.
c a      real/double precision array  length licn.  holds non-zeros of
c     matrix on entry and non-zeros of factors on exit.  reordered by
c     ma28d/dd and altered by subroutine ma30b/bd.
c licn   integer  length of arrays a and icn.  not altered by
c     subroutine.
c ivect,jvect  integer arrays of length nz.  hold row and column
c     indices of non-zeros respectively.  not altered by subroutine.
c icn    integer array of length licn.  same array as output from
c     ma28a/ad.  unchanged by ma28b/bd.
c ikeep  integer array of length 5*n.  same array as output from
c     ma28a/ad.  unchanged by ma28b/bd.
c iw     integer array  length 5*n.  used as workspace by ma28d/dd and
c     ma30b/bd.
c w      real/double precision array  length n.  used as workspace
c     by ma28d/dd,ma30b/bd and (optionally) mc24a/ad.
c iflag  integer  used as error flag with positive or zero value
c     indicating success.
c
      integer n, nz, licn, iw(n,5), iflag
      integer ikeep(n,5), ivect(nz), jvect(nz), icn(licn)
      double precision a(licn), w(n)
c
c private and common variables.
c unless otherwise stated common block variables are as in ma28a/ad.
c     those variables referenced by ma28b/bd are mentioned below.
c lp,mp  integers  used as in ma28a/ad as unit number for error and
c     warning messages, respectively.
c nlp    integer variable used to give value of lp to ma30e/ed.
c eps    real/double precision  ma30b/bd will output a positive value
c     for iflag if any modulus of the ratio of pivot element to the
c     largest element in its row (u part only) is less than eps (unless
c     eps is greater than 1.0 when no action takes place).
c rmin   real/double precision  variable equal to the value of this
c     minimum ratio in cases where eps is less than or equal to 1.0.
c meps,mrmin  real/double precision variables used by the subroutine
c     to communicate between common blocks ma28f/fd and ma30g/gd.
c idisp  integer array  length 2  the same as that used by ma28a/ad.
c     it is unchanged by ma28b/bd.
c
c see block data or ma28a/ad for further comments on variables
c     in common.
c see code for comments on private variables.
c
      logical grow, lblock, aborta, abortb, abort1, abort2, abort3,
     * lbig, lbig1
      integer idisp(2)
      double precision eps, meps, rmin, mrmin, resid, tol,
     * themax, big, dxmax, errmax, dres, cgce, tol1, big1
c
      common /ma28ed/ mp, lp, lblock, grow
      common /ma28fd/ eps, rmin, resid, irncp, icncp, minirn, minicn,
     * irank, abort1, abort2
      common /ma28gd/ idisp
      common /ma28hd/ tol, themax, big, dxmax, errmax, dres, cgce,
     * ndrop, maxit, noiter, nsrch, istart, lbig
      common /ma30ed/ nlp, aborta, abortb, abort3
      common /ma30gd/ meps, mrmin
      common /ma30id/ tol1, big1, ndrop1, nsrch1, lbig1
c
c check to see if elements were dropped in previous ma28a/ad call.
      if (ndrop.eq.0) go to 10
      iflag = -15
      write (6,99999) iflag, ndrop
      go to 70
   10 iflag = 0
      meps = eps
      nlp = lp
c simple data check on variables.
      if (n.gt.0) go to 20
      iflag = -11
      if (lp.ne.0) write (lp,99998) n
      go to 60
   20 if (nz.gt.0) go to 30
      iflag = -10
      if (lp.ne.0) write (lp,99997) nz
      go to 60
   30 if (licn.ge.nz) go to 40
      iflag = -9
      if (lp.ne.0) write (lp,99996) licn
      go to 60
c
   40 call ma28dd(n, a, licn, ivect, jvect, nz, icn, ikeep, ikeep(1,4),
     * ikeep(1,5), ikeep(1,2), ikeep(1,3), iw(1,3), iw, w(1), iflag)
c themax is largest element in matrix.
      themax = w(1)
      if (lbig) big1 = themax
c idup equals one if there were duplicate elements, zero otherwise.
      idup = 0
      if (iflag.eq.(n+1)) idup = 1
      if (iflag.lt.0) go to 60
c
c perform row-gauss elimination on the structure received from ma28d/dd
      call ma30bd(n, icn, a, licn, ikeep, ikeep(1,4), idisp,
     * ikeep(1,2), ikeep(1,3), w, iw, iflag)
c
c transfer common block information.
      if (lbig) big1 = big
      rmin = mrmin
      if (iflag.ge.0) go to 50
      iflag = -2
      if (lp.ne.0) write (lp,99995)
      go to 60
c
c optionally calculate the growth parameter.
   50 i1 = idisp(1)
      iend = licn - i1 + 1
      if (grow) call mc24ad(n, icn, a(i1), iend, ikeep, ikeep(1,4), w)
c increment estimate by largest element in input matrix.
      if (grow) w(1) = w(1) + themax
      if (grow .and. n.gt.1) w(2) = themax
c set flag if the only error is due to duplicate elements.
      if (idup.eq.1 .and. iflag.ge.0) iflag = -14
      go to 70
   60 if (lp.ne.0) write (lp,99994)
   70 return
99999 format (39h error return from ma28b/bd with iflag=, i4/i7, 4h ent,
     * 39hries dropped from structure by ma28a/ad)
99998 format (36x, 17hn out of range = , i10)
99997 format (36x, 18hnz non positive = , i10)
99996 format (36x, 17hlicn too small = , i10)
99995 format (36x, 26herror return from ma30b/bd)
99994 format (36h+error return from ma28b/bd because )
      end
      subroutine ma28dd(n, a, licn, ivect, jvect, nz, icn, lenr, lenrl,
     * lenoff, ip, iq, iw1, iw, w1, iflag)
c this subroutine need never be called by the user directly.
c     it sorts the user's matrix into the structure of the decomposed
c     form and checks for the presence of duplicate entries or
c     non-zeros lying outside the sparsity pattern of the decomposition
c     it also calculates the largest element in the input matrix.
      double precision a(licn), zero, w1, aa
      integer iw(n,2), idisp(2)
      integer icn(licn), ivect(nz), jvect(nz), ip(n), iq(n),
     * lenr(n), iw1(n,3), lenrl(n), lenoff(n)
      logical lblock, grow, blockl
      common /ma28ed/ lp, mp, lblock, grow
      common /ma28gd/ idisp
      data zero /0.0d0/
      blockl = lenoff(1).ge.0
c iw1(i,3)  is set to the block in which row i lies and the
c     inverse permutations to ip and iq are set in iw1(.,1) and
c     iw1(.,2) resp.
c pointers to beginning of the part of row i in diagonal and
c   off-diagonal blocks are set in iw(i,2) and iw(i,1) resp.
      iblock = 1
      iw(1,1) = 1
      iw(1,2) = idisp(1)
      do 10 i=1,n
        iw1(i,3) = iblock
        if (ip(i).lt.0) iblock = iblock + 1
        ii = iabs(ip(i)+0)
        iw1(ii,1) = i
        jj = iq(i)
        jj = iabs(jj)
        iw1(jj,2) = i
        if (i.eq.1) go to 10
        if (blockl) iw(i,1) = iw(i-1,1) + lenoff(i-1)
        iw(i,2) = iw(i-1,2) + lenr(i-1)
   10 continue
c place each non-zero in turn into its correct location
c    in the a/icn array.
      idisp2 = idisp(2)
      do 170 i=1,nz
c necessary to avoid reference to unassigned element of icn.
        if (i.gt.idisp2) go to 20
        if (icn(i).lt.0) go to 170
   20   iold = ivect(i)
        jold = jvect(i)
        aa = a(i)
c this is a dummy loop for following a chain of interchanges.
c   it will be executed nz times in total.
        do 140 idummy=1,nz
c perform some validity checks on iold and jold.
          if (iold.le.n .and. iold.gt.0 .and. jold.le.n .and.
     *     jold.gt.0) go to 30
          if (lp.ne.0) write (lp,99999) i, a(i), iold, jold
          iflag = -12
          go to 180
   30     inew = iw1(iold,1)
          jnew = iw1(jold,2)
c are we in a valid block and is it diagonal or off-diagonal?
          if (iw1(inew,3)-iw1(jnew,3)) 40, 60, 50
   40     iflag = -13
          if (lp.ne.0) write (lp,99998) iold, jold
          go to 180
   50     j1 = iw(inew,1)
          j2 = j1 + lenoff(inew) - 1
          go to 110
c element is in diagonal block.
   60     j1 = iw(inew,2)
          if (inew.gt.jnew) go to 70
          j2 = j1 + lenr(inew) - 1
          j1 = j1 + lenrl(inew)
          go to 110
   70     j2 = j1 + lenrl(inew)
c binary search of ordered list  .. element in l part of row.
          do 100 jdummy=1,n
            midpt = (j1+j2)/2
            jcomp = iabs(icn(midpt)+0)
            if (jnew-jcomp) 80, 130, 90
   80       j2 = midpt
            go to 100
   90       j1 = midpt
  100     continue
          iflag = -13
          if (lp.ne.0) write (lp,99997) iold, jold
          go to 180
c linear search ... element in l part of row or off-diagonal blocks.
  110     do 120 midpt=j1,j2
            if (iabs(icn(midpt)+0).eq.jnew) go to 130
  120     continue
          iflag = -13
          if (lp.ne.0) write (lp,99997) iold, jold
          go to 180
c equivalent element of icn is in position midpt.
  130     if (icn(midpt).lt.0) go to 160
          if (midpt.gt.nz .or. midpt.le.i) go to 150
          w1 = a(midpt)
          a(midpt) = aa
          aa = w1
          iold = ivect(midpt)
          jold = jvect(midpt)
          icn(midpt) = -icn(midpt)
  140   continue
  150   a(midpt) = aa
        icn(midpt) = -icn(midpt)
        go to 170
  160   a(midpt) = a(midpt) + aa
c set flag for duplicate elements.
        iflag = n + 1
  170 continue
c reset icn array  and zero elements in l/u but not in a.
c also calculate maximum element of a.
  180 w1 = zero
      do 200 i=1,idisp2
        if (icn(i).lt.0) go to 190
        a(i) = zero
        go to 200
  190   icn(i) = -icn(i)
        w1 = dmax1(w1,dabs(a(i)))
  200 continue
      return
99999 format (9h element , i6, 12h with value , 1pd22.14, 10h has indic,
     * 3hes , i8, 2h ,, i8/36x, 20hindices out of range)
99998 format (36x, 8hnon-zero, i7, 2h ,, i6, 23h in zero off-diagonal b,
     * 4hlock)
99997 format (36x, 8h element, i6, 2h ,, i6, 23h was not in l/u pattern)
      end
      subroutine ma30bd(n, icn, a, licn, lenr, lenrl, idisp, ip, iq, w,
     * iw, iflag)
c ma30b/bd performs the lu decomposition of the diagonal blocks of a
c     new matrix paq of the same sparsity pattern, using information
c     from a previous call to ma30a/ad. the entries of the input
c     matrix  must already be in their final positions in the lu
c     decomposition structure.  this routine executes about five times
c     faster than ma30a/ad.
c
c we now describe the argument list for ma30b/bd. consult ma30a/ad for
c     further information on these parameters.
c n  is an integer variable set to the order of the matrix.
c icn is an integer array of length licn. it should be unchanged
c     since the last call to ma30a/ad. it is not altered by ma30b/bd.
c a  is a real/double precision array of length licn the user must set
c     entries idisp(1) to idisp(2) to contain the entries in the
c     diagonal blocks of the matrix paq whose column numbers are held
c     in icn, using corresponding positions. note that some zeros may
c     need to be held explicitly. on output entries idisp(1) to
c     idisp(2) of array a contain the lu decomposition of the diagonal
c     blocks of paq. entries a(1) to a(idisp(1)-1) are neither
c     required nor altered by ma30b/bd.
c licn  is an integer variable which must be set by the user to the
c     length of arrays a and icn. it is not altered by ma30b/bd.
c lenr,lenrl are integer arrays of length n. they should be
c     unchanged since the last call to ma30a/ad. they are not altered
c     by ma30b/bd.
c idisp  is an integer array of length 2. it should be unchanged since
c     the last call to ma30a/ad. it is not altered by ma30b/bd.
c ip,iq  are integer arrays of length n. they should be unchanged
c     since the last call to ma30a/ad. they are not altered by
c     ma30b/bd.
c w  is a real/double precision array of length n which is used as
c     workspace by ma30b/bd.
c iw  is an integer array of length n which is used as workspace by
c     ma30b/bd.
c iflag  is an integer variable. on output from ma30b/bd, iflag has
c     the value zero if the factorization was successful, has the
c     value i if pivot i was very small and has the value -i if an
c     unexpected singularity was detected at stage i of the
c     decomposition.
c
      double precision a(licn), w(n), au, eps, rowmax, zero, one, rmin,
     * tol, big
      logical abort1, abort2, abort3, stab, lbig
      integer iw(n), idisp(2), pivpos
      integer icn(licn), lenr(n), lenrl(n), ip(n), iq(n)
c see block data for comments on variables in common.
      common /ma30ed/ lp, abort1, abort2, abort3
      common /ma30id/ tol, big, ndrop, nsrch, lbig
      common /ma30gd/ eps, rmin
      data zero /0.0d0/, one /1.0d0/
      stab = eps.le.one
      rmin = eps
      ising = 0
      iflag = 0
      do 10 i=1,n
        w(i) = zero
   10 continue
c set up pointers to the beginning of the rows.
      iw(1) = idisp(1)
      if (n.eq.1) go to 25
      do 20 i=2,n
        iw(i) = iw(i-1) + lenr(i-1)
   20 continue
c
c   ****   start  of main loop    ****
c at step i, row i of a is transformed to row i of l/u by adding
c     appropriate multiples of rows 1 to i-1.
c     .... using row-gauss elimination.
   25 do 160 i=1,n
c istart is beginning of row i of a and row i of l.
        istart = iw(i)
c ifin is end of row i of a and row i of u.
        ifin = istart + lenr(i) - 1
c ilend is end of row i of l.
        ilend = istart + lenrl(i) - 1
        if (istart.gt.ilend) go to 90
c load row i of a into vector w.
        do 30 jj=istart,ifin
          j = icn(jj)
          w(j) = a(jj)
   30   continue
c
c add multiples of appropriate rows of  i to i-1  to row i.
        do 70 jj=istart,ilend
          j = icn(jj)
c ipivj is position of pivot in row j.
          ipivj = iw(j) + lenrl(j)
c form multiplier au.
          au = -w(j)/a(ipivj)
          if (lbig) big = dmax1(dabs(au),big)
          w(j) = au
c au * row j (u part) is added to row i.
          ipivj = ipivj + 1
          jfin = iw(j) + lenr(j) - 1
          if (ipivj.gt.jfin) go to 70
c innermost loop.
          if (lbig) go to 50
          do 40 jayjay=ipivj,jfin
            jay = icn(jayjay)
            w(jay) = w(jay) + au*a(jayjay)
   40     continue
          go to 70
   50     do 60 jayjay=ipivj,jfin
            jay = icn(jayjay)
            w(jay) = w(jay) + au*a(jayjay)
            big = dmax1(dabs(w(jay)),big)
   60     continue
   70   continue
c
c reload w back into a (now l/u)
        do 80 jj=istart,ifin
          j = icn(jj)
          a(jj) = w(j)
          w(j) = zero
   80   continue
c we now perform the stability checks.
   90   pivpos = ilend + 1
        if (iq(i).gt.0) go to 140
c matrix had singularity at this point in ma30a/ad.
c is it the first such pivot in current block ?
        if (ising.eq.0) ising = i
c does current matrix have a singularity in the same place ?
        if (pivpos.gt.ifin) go to 100
        if (a(pivpos).ne.zero) go to 170
c it does .. so set ising if it is not the end of the current block
c check to see that appropriate part of l/u is zero or null.
  100   if (istart.gt.ifin) go to 120
        do 110 jj=istart,ifin
          if (icn(jj).lt.ising) go to 110
          if (a(jj).ne.zero) go to 170
  110   continue
  120   if (pivpos.le.ifin) a(pivpos) = one
        if (ip(i).gt.0 .and. i.ne.n) go to 160
c end of current block ... reset zero pivots and ising.
        do 130 j=ising,i
          if ((lenr(j)-lenrl(j)).eq.0) go to 130
          jj = iw(j) + lenrl(j)
          a(jj) = zero
  130   continue
        ising = 0
        go to 160
c matrix had non-zero pivot in ma30a/ad at this stage.
  140   if (pivpos.gt.ifin) go to 170
        if (a(pivpos).eq.zero) go to 170
        if (.not.stab) go to 160
        rowmax = zero
        do 150 jj=pivpos,ifin
          rowmax = dmax1(rowmax,dabs(a(jj)))
  150   continue
        if (dabs(a(pivpos))/rowmax.ge.rmin) go to 160
        iflag = i
        rmin = dabs(a(pivpos))/rowmax
c   ****    end of main loop    ****
  160 continue
c
      go to 180
c   ***   error return   ***
  170 if (lp.ne.0) write (lp,99999) i
      iflag = -i
c
  180 return
99999 format (54h error return from ma30b/bd singularity detected in ro,
     * 1hw, i8)
      end
c######date   01 jan 1984     copyright ukaea, harwell.
c######alias mc24ad
      subroutine mc24ad(n,icn,a,licn,lenr,lenrl,w)
      double precision a(licn),w(n),amaxl,wrowl,amaxu,zero
      integer   icn(licn),lenr(n),lenrl(n)
      data zero/0.0d0/
      amaxl=zero
      do 10 i=1,n
 10   w(i)=zero
      j0=1
      do 100 i=1,n
      if (lenr(i).eq.0) go to 100
      j2=j0+lenr(i)-1
      if (lenrl(i).eq.0) go to 50
c calculation of 1-norm of l.
      j1=j0+lenrl(i)-1
      wrowl=zero
      do 30 jj=j0,j1
 30   wrowl=wrowl+dabs(a(jj))
c amaxl is the maximum norm of columns of l so far found.
      amaxl=dmax1(amaxl,wrowl)
      j0=j1+1
c calculation of norms of columns of u (max-norms).
 50   j0=j0+1
      if (j0.gt.j2) go to 90
      do 80 jj=j0,j2
      j=icn(jj)
 80   w(j)=dmax1(dabs(a(jj)),w(j))
 90   j0=j2+1
 100  continue
c amaxu is set to maximum max-norm of columns of u.
      amaxu=zero
      do 200 i=1,n
 200  amaxu=dmax1(amaxu,w(i))
c grofac is max u max-norm times max l 1-norm.
      w(1)=amaxl*amaxu
      return
      end
