/*****************************************************************/
/*      contactproxy.c                                           */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "proxyjobdesc.h"
#include "proxy.h"
#include "netsolve.h"
#include <signal.h>

/*
 * This function returns a communicator to the local proxy.
 * It just calls contactHost but specifies no hostname or
 * IP address, so that the local host is contacted.
 * 
 */
NS_Communicator *contactProxy(int retry)
{
  NS_Communicator *comm;

  comm = contactHost(NULL,0,proxy_port,DATA_RAW);

  /* if failure to contact proxy, start a new one */
  if(retry && (comm == NULL)){
    netslinit(NULL);
    comm = contactHost(NULL,0,proxy_port,DATA_RAW);
  }

  return comm;
} 

