/*****************************************************************/
/*      jobdesc.c                                                */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include <sys/stat.h>
#include <fcntl.h>
#include "core.h"
#include "proxyjobdesc.h"
#include "netsolveproxy.h"

/*
 * newJobDesc()
 */
NS_JobDesc *newJobDesc()
{
  NS_JobDesc *new;

  new = (NS_JobDesc*)calloc(1,sizeof(NS_JobDesc));
  return new;
}

/*
 * freeJobDesc()
 */
void freeJobDesc(NS_JobDesc *jd)
{
  if (jd == NULL)
    return;
  free(jd);
  return;
}

/*
 * sendJobDesc()
 */
int sendJobDesc(NS_Communicator *comm,NS_JobDesc *jd)
{
  if ((sendInt(comm,jd->error_code) == -1) ||
      (sendIPaddr(comm,&(jd->IPaddr)) == -1) ||
      (sendInt(comm,jd->port) == -1) ||
      (sendInt(comm,jd->pid) == -1))
    return -1;
  return 0;
}
  
/*
 * recvJobDesc()
 */
NS_JobDesc *recvJobDesc(NS_Communicator *comm)
{
  NS_JobDesc *jd = newJobDesc();

  if ((recvInt(comm,&(jd->error_code)) == -1) ||
      (recvIPaddr(comm,&(jd->IPaddr)) == -1) ||
      (recvInt(comm,&(jd->port)) == -1) ||
      (recvInt(comm,&(jd->pid)) == -1))
  {
    free(jd);
    return NULL;
  }
  return jd;
}
