#include <stdio.h> 
#include "globus_gram_client.h"

static void callback_func(void * user_callback_arg,
                          char * job_contact,
                          int state,
                          int errorcode);

#if 0
#define QUIDAM_FORK "quidam.ucsd.edu:754:/C=US/O=Globus/O=University of California San Diego/OU=PCL/CN=quidam.ucsd.edu-fork"

#define FORK_FMT "%s:754:/C=US/O=Globus/O=University of California San Diego/OU=PCL/CN=quidam.ucsd.edu-fork"

#define PWD "/net/quidam/nakada/NetSolve-1.2/GlobusTest/"
#define SERVER_EXECUTABLE  PWD "server"
#define STDERR "(stderr=" PWD "stderr)"
#define STDOUT "(stdout=" PWD "stdout)"
#endif 

#define EXEC_SPECIFICATION "&(executable = " SERVER_EXECUTABLE ")"
#define SPECIFICATION EXEC_SPECIFICATION STDERR STDOUT
#define JOBSTATE_MASK 31

#define EXEC_FMT "&(executable = %s)"
#define SPEC_FMT EXEC_FMT "(arguments=%s %d %d)"

/* This whole structure is the monitor */

typedef struct{
  globus_mutex_t mutex;
  globus_cond_t cond;
  globus_bool_t done;
} my_monitor_t;


void start_globus(){
  int rc;
  if ((rc = globus_module_activate(GLOBUS_GRAM_CLIENT_MODULE)) 
      != GLOBUS_SUCCESS)
    {
      printf("\tERROR: gram module activation failed\n");
      exit(1);
    }
}

static my_monitor_t Monitor;
static char * job_contact; /* This is the identifier for the job,
			    * returned by globus_gram_job_request
			    */


int InvokeGRAM(char * rm_contact, char * serverpath, char* myname, int port, int input){
  char * callback_contact; /* This is the identifier for 
			    * the callback, returned by 
			    * globus_gram_job_request
			    */
  int rc;
  char specification[1024];

  sprintf(specification, SPEC_FMT, serverpath, myname, port, input);

  fprintf(stderr, "rm_contact = %s\nspecification = %s\n", 
	  rm_contact, specification);;
  start_globus();

  globus_mutex_init(&Monitor.mutex, (globus_mutexattr_t *) NULL);
  globus_cond_init(&Monitor.cond, (globus_condattr_t *) NULL);
  globus_mutex_lock(&Monitor.mutex);
  Monitor.done = GLOBUS_FALSE;
  globus_mutex_unlock(&Monitor.mutex);
  globus_gram_client_callback_allow(callback_func,
				    (void *) &Monitor,
				    &callback_contact);
  
  printf("\n\tTEST: submitting to resource manager...\n");


  rc = globus_gram_client_job_request(rm_contact,
				      specification,
				      JOBSTATE_MASK,
				      callback_contact,
				      &job_contact);
    if (rc != 0) /* if there is an error */
    {
        printf("TEST: gram error: %d - %s\n", 
                rc, 
                /* translate the error into english */
                globus_gram_client_error_string(rc));
        exit(1);
    }
}



int WaitforGRAM(){
    globus_mutex_lock(&Monitor.mutex);
    while (!Monitor.done)
    {
      globus_cond_wait(&Monitor.cond, &Monitor.mutex);
    } /* endwhile */

    globus_mutex_unlock(&Monitor.mutex);
    globus_mutex_destroy(&Monitor.mutex);
    globus_cond_destroy(&Monitor.cond);
    globus_gram_client_job_contact_free(job_contact);

    globus_module_deactivate(GLOBUS_GRAM_CLIENT_MODULE);
}

void callback_func(void * user_callback_arg,
                   char * job_contact,
                   int state,
                   int errorcode)
{
    my_monitor_t * Monitor = (my_monitor_t *) user_callback_arg;

    switch(state)
    {
    case GLOBUS_GRAM_CLIENT_JOB_STATE_PENDING:
            printf("\tTEST: Got GLOBUS_GRAM_CLIENT_JOB_STATE_PENDING"
                   " from job manager\n");
	break; /* Reports state change to the user */

    case GLOBUS_GRAM_CLIENT_JOB_STATE_ACTIVE:
            printf("\tTEST: Got GLOBUS_GRAM_CLIENT_JOB_STATE_ACTIVE"
                   " from job manager\n");
	break; /* Reports state change to the user */
   
    case GLOBUS_GRAM_CLIENT_JOB_STATE_FAILED:
            printf("\tTEST: Got GLOBUS_GRAM_CLIENT_JOB_STATE_FAILED"
                   " from job manager\n");
        globus_mutex_lock(&Monitor->mutex);
        Monitor->done = GLOBUS_TRUE;
        globus_cond_signal(&Monitor->cond);
        globus_mutex_unlock(&Monitor->mutex);
	break; /* Reports state change to the user */

    case GLOBUS_GRAM_CLIENT_JOB_STATE_DONE:
      printf("\tTEST: Got GLOBUS_GRAM_CLIENT_JOB_STATE_DONE"
                   " from job manager\n");
        globus_mutex_lock(&Monitor->mutex);
        Monitor->done = GLOBUS_TRUE;
        globus_cond_signal(&Monitor->cond);
        globus_mutex_unlock(&Monitor->mutex);
	break; /* Reports state change to the user */
    }
}
