/*****************************************************************/
/*      proxyutil.c                                              */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"

#ifndef WIN32
#include <unistd.h>
#include <sys/socket.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>

#include "globusjobdesc.h"
#include "globusproxy.h"

int InvokeGRAM(char *, char *, NS_IPaddr_type,int);
int LDAP_start();
char *LDAP_ns_search(char *, char *);
char *LDAP_contact_search(char*);
int LDAP_end();

#define ATTRIBUTE "totaltest"

/*
 * submitProblemToGlobus()
 */
int submitProblemToGlobus(NS_ProblemDesc *pd,NS_IPaddr_type IPaddr,
                          int *start_time, int *newport, int *data_format,
                          NS_JobDesc **jd)
{
  NS_Socket_type listening_socket;
  NS_Communicator *comm;
  int encoding;
  int tag,i;
  time_t now; 
  char *agent_name;
  int ack;
  int bogus_port;
  int sock;
  NS_IPaddr_type server_IPaddr;
  char *serverpath;
  char *servername="torc10.cs.utk.edu";
  char *contact;
  char buffer[256];
  
  /* Setting up a socket for listening */
  listening_socket = bindToFirstAvailablePort(3000,&bogus_port);
  if (listening_socket == -1)
  {
    return -1;
  }
  listen(listening_socket,MAX_CONNECTIONS);

  /* Beginning of Globus stuff */

  /* Contacting LDAP() */
  LDAP_start();

  if ((contact  = LDAP_contact_search(servername)) == NULL){
    fprintf(stderr, "failed to get contact for %s\n", servername);
    LDAP_end();
    return -1;
  }

  if ((serverpath = LDAP_ns_search(servername, ATTRIBUTE)) == NULL){
    fprintf(stderr, "failed to get functionname for %s\n", ATTRIBUTE);
    LDAP_end();
    return -1;
  }
  LDAP_end();

  /* Invoking the GRAM */
    if (InvokeGRAM(contact, serverpath, 
			    getMyIPaddr(), bogus_port) == -1)
      return -1;

  /* end of GLOBUS stuff */

  /* accepting connection from the server */
  if ((sock = acceptConnection(listening_socket)) == -1)
  {
    close(listening_socket);
    return -1;
  }

  comm = acceptTransaction(sock);
  if (comm == NULL)
  {
    close(listening_socket);
    return -1;
  }

  /* Get the server's IP and port */
  if ((recvIPaddr(comm,&server_IPaddr) == -1) ||
      (recvInt(comm,newport) == -1))
  {
    endTransaction(comm);
    return -1;
  }

  /* send back the pd and the real port number for the proxy */
  if ((sendProblemDesc(comm,pd) == -1)||
      (sendInt(comm,myport) == -1))
  {
    endTransaction(comm);
    return -1;
  }
  endTransaction(comm);
 
  time(&now);
  *start_time = (int)now;
  *data_format = -1;

  *jd = newJobDesc();
  (*jd)->error_code = NetSolveNotReady;
  (*jd)->IPaddr = server_IPaddr;
  (*jd)->pid = 0;
  (*jd)->port = *newport;
  return 1;
}

/*
 * forwardFailure()
 */
int forwardFailure(NS_IPaddr_type IPaddr, char *nickname, int error_type)
{
  NS_Communicator *comm_to_agent;
  int tag;

    /* Contact the agent */
  comm_to_agent = contactHost(agent,0,AGENT_PORT,DATA_XDR);
  if (comm_to_agent == NULL)
  {
    netsolvePerror("contactHost()");
    return -1;
  }

  if ((sendInt(comm_to_agent,NS_PROT_SV_FAILURE) == -1) ||
     (sendIPaddr(comm_to_agent,&IPaddr) == -1) ||
     (sendString(comm_to_agent,nickname) == -1) ||
     (sendInt(comm_to_agent,error_type) == -1))
  {
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return -1;
  }
  endTransaction(comm_to_agent);
  return 1;
}

/*
 * rmJobDesc()
 */
void rmJobDesc(int ID)
{
  NS_Communicator *comm;
  int tag;

  comm = contactHost(NULL,getMyIPaddr(),myport,DATA_RAW);
  if (comm == NULL)
  {
    netsolvePerror("contactHost()");
    return;
  } 
  
  if ((sendInt(comm,NS_PROT_RM_JOB_DESC) == -1)||
      (sendInt(comm,ID) == -1))
  {
    endTransaction(comm);
    netsolvePerror("sendInt()");
    return;
  }
  endTransaction(comm);
  return; 
}

/*
 * requestInsertJobDesc()
 *
 * returns an ID
 */
int requestInsertJobDesc(NS_JobDesc *jd)
{
  NS_Communicator *comm;
  int tag;
  int ID;

  comm = contactHost(NULL,getMyIPaddr(),myport,DATA_RAW);
  if (comm == NULL)
  {
    netsolvePerror("contactHost()");
    return -1;
  } 
  
  if ((sendInt(comm,NS_PROT_NEW_JOB_DESC) == -1)||
      (sendJobDesc(comm,jd) == -1))
  {
    endTransaction(comm);
    netsolvePerror("");
    return -1;
  }
  if (recvInt(comm,&ID) == -1)
  {
    endTransaction(comm);
    netsolvePerror("recvIntI()");
    return -1;
  }
  endTransaction(comm);
  return ID;
}

/*
 * getAServer()
 */
NS_ServerDesc *getAServer(NS_IPaddr_type IPaddr, char *agent_name)
{
  int tag;
  int status;
  NS_Communicator *comm;
  NS_ServerDesc *sd;

  comm = contactHost(agent_name,0,AGENT_PORT,DATA_XDR);
  if (comm == NULL)
  {
    return NULL;
  }

  if ((sendInt(comm,NS_PROT_SV_INFO) == -1) ||
      (sendIPaddr(comm,&IPaddr) == -1))
  {
    endTransaction(comm);
    return NULL;
  }
  
  if (recvInt(comm,&status) == -1)
  {
    endTransaction(comm);
    return NULL;
  }
  if (status == NS_PROT_SV_NOT_FOUND)
  {
    ns_errno = NetSolveUnknownServer;
    return NULL;
  }
  sd = recvServerDesc(comm);
  if (sd == NULL)
    return NULL;

  ns_errno = NetSolveOK;
  return sd;
}

/*
 * insertJobDesc()
 */
int insertJobDesc(NS_JobDesc *jd)
{
  int i;

  for (i=0;i<NB_MAX_JOBS;i++)
  {
    if (jobs[i] == NULL)
    {
      jobs[i] = jd;
      return i;
    }
  }
  return -1;
}
