/**
* ProblemDescription
*
* @version 2.0, 5 April 1998
* @author Zach Eyler-Walker (zwalker@cs.utk.edu)
* 
* @version 1.1, 26 Jan 1998 
* @author Henri Casanova (casanova@cs.utk.edu)
*
**/

import java.io.*;
import java.io.IOException;
import java.util.Enumeration;

public class ProblemDescription {

  private String description;
  private String name;
  private String path;
  private java.util.Vector inputObjects;
  private java.util.Vector outputObjects;
  private IOSequence inputobjectSequence;
  private IOSequence outputobjectSequence;
  private int argCount;
  private IOSequence callSequence;
  private Arguments argmts;
  private MatlabMerge matlabMerge;
  private int maxCount;
  private LinkedList functions;
  private LinkedList dashis;
  private LinkedList includes;
  private LinkedList libdirs;
  private LinkedList libs;

  private Complexity complexity;

  private String language;
  private String major;
  private String customName;
  private String code;

  /**
   * 
   * This is the constructor for the ProblemDescription class.
   * 
   **/

  public ProblemDescription() {
    inputObjects = new java.util.Vector();
    outputObjects = new java.util.Vector();
    argCount = 0;
    functions = new LinkedList();
    dashis = new LinkedList();  
    includes = new LinkedList();  
    libdirs = new LinkedList();
    libs = new LinkedList();
    complexity = new Complexity(1,1);
  }

  public void addInputObject(Objects newObject) {
    inputObjects.addElement(newObject);
    argCount += newObject.getCallObj().getArgCount();
  }

  public Objects getInputObject(int idx) {
    return (Objects) inputObjects.elementAt(idx);
  }

  public Enumeration getInputs() {
    return inputObjects.elements();
  }

  public int numInputObjects() {
    return inputObjects.size();
  }

  public void addOutputObject(Objects newObject) {
    outputObjects.addElement(newObject);
    argCount += newObject.getCallObj().getArgCount();
  }

  public Objects getOutputObject(int idx) {
    return (Objects) outputObjects.elementAt(idx);
  }

  public Enumeration getOutputs() {
    return outputObjects.elements();
  }

  public int numOutputObjects() {
    return outputObjects.size();
  }

  public void setDescription(String newDesc) {
    description = newDesc;
  }

  public String getDescription() {
    return description;
  }

  public void setName(String newName) {
    name = newName;
  }

  public String getName() {
    return name;
  }

  public void setPath(String newPath) {
    path = newPath;
  }

  public String getPath() {
    return path;
  }

  public void setInputObjectSequence(IOSequence newSequence) {
    inputobjectSequence = newSequence;
  }

  public IOSequence getInputObjectSequence() {
    return inputobjectSequence;
  }

  public void setOutputObjectSequence(IOSequence newSequence) {
    outputobjectSequence = newSequence;
  }

  public IOSequence getOutputObjectSequence() {
    return outputobjectSequence;
  }

  public void setArgCount(int newCount) {
    argCount = newCount;
  }

  public int getArgCount() {
    return argCount;
  }

  public int findMnemonic(String m) {
    for(int i=0;i<argCount;i++)
      if(m.equals(argmts.getNetsolveArg(i)))
         return i+1;

    return -1;
  }

  public void setCallSequence(IOSequence newSequence) {
    callSequence = newSequence;
  }

  public IOSequence getCallSequence() {
    return callSequence;
  }

  public void setArguments(Arguments newArgs) {
    argmts = newArgs;
  }
  public Arguments getArguments() {
    return argmts;
  }

  public void setMatlabMerge(MatlabMerge newMM) {
    matlabMerge = newMM;
  }

  public MatlabMerge getMatlabMerge() {
    return matlabMerge;
  }

  public void setMaxCount(int newCount) {
    maxCount = newCount;
  }
  public int getMaxCount() {
    return maxCount;
  }

  public void addFunction(String newFunc) {
    functions.insert(newFunc);
  }

  public Enumeration getFunctions()
  {
    return functions.names();
  }
   

  public void clearFunctions() {
    functions.clear();
  }

  public void addDashI(String newDashI) {
    dashis.insert(newDashI);
  }
  
  public Enumeration getDashIs()
  {
   return dashis.names();
  }

  public void clearDashIs() {
    dashis.clear();
  }

  public void addInclude(String newInclude) {
    includes.insert(newInclude);
  }
  
  public Enumeration getIncludes()
  {
   return includes.names();
  }  

  public void clearIncludes() {
    includes.clear();
  }

  public void addLibdir(String newLibdir) {
    libdirs.insert(newLibdir);
  }

  public Enumeration getLibdirs()
  {
   return libdirs.names();
  }

  public void clearLibdirs() {
    libdirs.clear();
  }

  public void addLib(String newLib) {
    libs.insert(newLib);
  }
 
  public Enumeration getLibs()
  {
    return libs.names();
  } 

  public void clearLibs() {
    libs.clear();
  }

  public void setComplexity(Complexity newComplexity) {
    complexity = newComplexity;
  }
  public Complexity getComplexity() {
    return complexity;
  }

  public void setLanguage(String newLang) {
    language = newLang;
  }
  public String getLanguage() {
    return language;
  }

  public void setMajor(String newMajor) {
    major = newMajor;
  }
  public String getMajor() {
    return major;
  }

  public void setCustomName(String newName) {
    customName = newName;
  }
  public String getCustomName() {
    return customName;
  }

  public void setCode(String newCode) {
    code = newCode;
  }

  public String getCode() {
    return code;
  }

  public void writeOLD(Writer out, String FileName) throws IOException
  {
  out.write("## Generated using XML gui ##\n\n");
  out.write("@PROBLEM " + name+ "\n");
  LinkedList savell = functions;
  olddumpLinkedList(functions, out, "FUNCTION");
  functions = savell;
  savell = includes;
  olddumpLinkedList(includes, out, "INCLUDE");
  includes = savell;
  savell = dashis;
  olddumpLinkedList(dashis, out, "DASHI");
  dashis = savell;
  savell = libdirs;
  olddumpLinkedList(libdirs, out, "LIB");
  libdirs = savell;
  savell = libs;
  olddumpLinkedList(libs, out, "LIB");
  libs = savell;

  out.write("@LANGUAGE " + language + "\n");
  out.write("@MAJOR " + major + "\n");
  out.write("@PATH " + path + "\n");
  out.write("@DESCRIPTION \n" + description + "\n");
 
 // writeXXX would be for old pdf file 
 
    out.write("@INPUT ");
    writeInOut(out, inputobjectSequence, inputObjects);

    out.write("@OUTPUT ");
    writeInOut(out, outputobjectSequence, outputObjects);

   
  if(matlabMerge != null) 
   out.write("@MATLABMERGE " + matlabMerge.getFirstObjectNum() 
          + " , " + matlabMerge.getSecondObjectNum() + "\n");

  if(customName != null)
      out.write("@CUSTOMIZED " + customName + "\n");

   out.write("@COMPLEXITY "+complexity.getA()+ "," +complexity.getB()+ "\n");
     
   out.write("@CALLINGSEQUENCE \n");
   writeArgs(out);

   out.write("@CODE \n" + code + "\n@END_CODE\n");

   out.flush();

// just incase if the user wants to reload file

  // change the extension though
   StringBuffer sb = new StringBuffer(FileName);
   FileName  = sb.append(".xmlpdf").toString();
   out = new FileWriter(FileName); 
    writeXML(out);
  }  // end of writeOLD

  private void writeArgs(Writer out) throws IOException
  {
    int idx;
    int size = argmts.getSize();

    for(int i=0; i < size; i++) {
      idx = callSequence.getElementAt(i);

      if(idx != -1)
        out.write("@ARG " +  argmts.getNetsolveArg( idx - 1 ) + "\n");
    }
  }


 private void writeInOut(Writer out, IOSequence seq, java.util.Vector v)
    throws IOException
  {
    Objects o;
    String tag;
    String objTag;
    String dataTag;

    int size = seq.getSize();

    out.write(size+"\n");

    for(int i=0;i<size;i++) 
    {
      o = (Objects) v.elementAt( seq.getElementAt(i) - 1);
      objTag = Objects.getObjectTag(o.getObjectType());
      dataTag = Objects.getDataTag(o.getDataType());

      out.write("@OBJECT " + objTag + " " + dataTag + " " +o.getName()+ "\n" +o.getDesc() + "\n");
    }
  }


 public void olddumpLinkedList(LinkedList l, Writer out, String XMLTag)
    throws IOException
 {
   
    String str;
    if(XMLTag.equals("INCLUDE"))
    { while( (str = (String) l.pop()) != null )
      out.write("@" + XMLTag + " <" + str + ">\n");
    }
    else
    { while( (str = (String) l.pop()) != null )
      out.write("@" + XMLTag + " " + str + "\n");
    }

  
     
  }



  /*  writeXML
   *
   */

  public void writeXML(Writer out) throws IOException
  {
    // XML Header
    out.write("<?xml version=\"1.0\"?>\n");
    out.write("<!DOCTYPE NetSolvePDF SYSTEM \"netsolve.dtd\">\n");
    out.write("<!-- Problem " + name + " automatically generated by PDGUI -->\n");

    // NetSolve PDF header
    out.write("<NetSolvePDF>\n");
    out.write("<Problem name=\"" + name + "\">\n");

    dumpLinkedList(functions, out, "Function", "name");
    dumpLinkedList(includes, out, "Include", "file");
    dumpLinkedList(dashis, out, "DashI", "path");
    dumpLinkedList(libdirs, out, "Lib", "path");
    dumpLinkedList(libs, out, "Lib", "path");
    
    out.write("<Language lang=\"" + language + "\"/>\n");
    out.write("<Major value=\"" + major + "\"/>\n");
    out.write("<Path value=\"" + path + "\"/>\n");
    out.write("<Description>\n" + description + "\n</Description>\n");

    out.write("<Input>\n");
    emitInOut(out, inputobjectSequence, inputObjects);
    out.write("</Input>\n");

    out.write("<Output>\n");
    emitInOut(out, outputobjectSequence, outputObjects);
    out.write("</Output>\n");

    if(matlabMerge != null) 
      out.write("<MatlabMerge num1=\"" + matlabMerge.getFirstObjectNum() 
          + "\" num2 =\"" + matlabMerge.getSecondObjectNum() + "\"/>\n");

    if(customName != null)
      out.write("<Customized value=\"" + customName + "\"/>\n");

    out.write("<Complexity num1=\"" + complexity.getA() 
        + "\" num2 =\"" + complexity.getB() + "\"/>\n");

    out.write("<CallingSequence>\n");
    emitArgs(out);
    out.write("</CallingSequence>\n");

    out.write("<Code>\n" + code + "\n</Code>\n");

    // End problem
    out.write("</Problem>\n");
    out.write("</NetSolvePDF>\n");

    out.flush();
  }

  private void emitArgs(Writer out) throws IOException
  {
    int idx;

    for(int i=0; i < argmts.getSize(); i++) {
      idx = callSequence.getElementAt(i);
  
      if(idx != -1)
        out.write("<Arg name=\"" +  argmts.getNetsolveArg( idx - 1 ) + "\"/>\n");
    }
  }

  private void emitInOut(Writer out, IOSequence seq, java.util.Vector v)
    throws IOException
  {
    Objects o;
    String tag;

    for(int i=0;i<seq.getSize();i++) {
      o = (Objects) v.elementAt( seq.getElementAt(i) - 1);

      if(o.getDataType() == Objects.NETSOLVE_NOTYPE) 
        tag = Objects.getObjectTag(o.getObjectType());
      else
        tag = Objects.getObjectTag(o.getObjectType()) + "_" + Objects.getDataTag(o.getDataType());

      out.write("<" + tag + " name=\"" + o.getName() + "\"> " + o.getDesc()
        + "</" +tag +">\n");
    }
  }

  public void dumpLinkedList(LinkedList l, Writer out, String XMLTag, String valTag)
    throws IOException
  {
    String str;

    while( (str = (String) l.pop()) != null ) 
      out.write("<" + XMLTag + " " + valTag + "=\"" + str + "\"/>\n");
  }
}
