import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
// import com.util.myjava.*;  // to import CustomLayout
import java.util.*;

public class OutputPanel extends JPanel implements ActionListener
{

 private JLabel Number_of_Outputs;
 DescriptionPanel dp = null;
 private int TotalOutputs;
 private int NewTotalOutputs;
 boolean ifTouched = false;


 private java.util.Vector OutputNames;
 
 private String[] DataTypeList = { "NO TYPE","INTEGER","FLOAT","DOUBLE","CHAR","BYTE","SIMPLE COMPLEX","DOUBLE COMPLEX"};

 private String[] ObjectTypeList = { "SCALAR","ARRAY-1D","ARRAY-2D","STRING","SPARSE MATRIX","FILE","UPF","STRING LIST","PACKED FILE"};

 java.util.Vector NameLabels;
 java.util.Vector DataTypeCBox;
 java.util.Vector ObjectTypeCBox;
 java.util.Vector DescriptionTextArea;

 private JPanel OutputDetailsPanel;
 CustomLayout cl = null;
 boolean UpdateCalled = false;



OutputPanel(DescriptionPanel dp)
 {
  this.dp = dp;
 
  Number_of_Outputs = new JLabel();
  
  OutputNames = new java.util.Vector();

  NameLabels = new java.util.Vector();
  DataTypeCBox = new java.util.Vector();
  ObjectTypeCBox = new java.util.Vector();
  DescriptionTextArea = new java.util.Vector();

  OutputDetailsPanel = new JPanel();
  OutputDetailsPanel.setBorder(BorderFactory.createTitledBorder("Output Details"));



  this.setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
  add(new JLabel(" "));
  add(new JLabel(" "));
 
  add(Number_of_Outputs);

  add(new JLabel(" "));
  add(new JLabel(" "));
  add(OutputDetailsPanel); // A panel that contains all the outputs detail
  add(new JLabel(" "));
  add(new JLabel(" "));

  Number_of_Outputs.setText("Number of Outputs: " +new Integer(TotalOutputs).toString());
//  OutputDetailsPanel.setPreferredSize(new Dimension(100,50));
  cl = new CustomLayout(new Dimension(8, 1));


  }       

 
 void UpdatePanel()
  {
   NewTotalOutputs = getOutputNumbers();
   if(NewTotalOutputs == 0)
      return;

   OutputNames = getOutputNames();


   if(NewTotalOutputs < 20)
     cl = new CustomLayout(new Dimension(8, 20));  // 20 just to have proper grid size
   else
     cl = new CustomLayout(new Dimension(8, NewTotalOutputs));  // else # of Outputs to have grid size



    if(!UpdateCalled)  // means update is not called again
    OutputDetailsPanel.setLayout(cl); // if called then dont setLayout


    JTextArea jt = new JTextArea();
    JScrollPane jp = new JScrollPane(jt);
    jp.setPreferredSize(new Dimension (100,20));



  if(TotalOutputs == NewTotalOutputs)  // name might differ so check
    checkNames();

  if(TotalOutputs > NewTotalOutputs)
  {
     OutputDetailsPanel.removeAll();
      TotalOutputs = 0;
   }


   Number_of_Outputs.setText("Number of Outputs: " +new Integer(NewTotalOutputs).toString());
   String str;
    OutputDetailsPanel.add(new JLabel("Sr. Name"),new Rectangle(0,0,1,1));
    OutputDetailsPanel.add(new JLabel("Object Type "),new Rectangle(1,0,2,1));
    OutputDetailsPanel.add(new JLabel("Data Type"),new Rectangle(3,0,2,1));
    OutputDetailsPanel.add(new JLabel("Description"),new Rectangle(5,0,3,1));


   for(int i =TotalOutputs;i<NewTotalOutputs;i++)
    {
     str = (i+1) +  "   "  +(String)OutputNames.elementAt(i);
     
     NameLabels.addElement(new JLabel(str));
     OutputDetailsPanel.add((JLabel)NameLabels.elementAt(i), new Rectangle(0,i+1,1,1));

     ObjectTypeCBox.addElement(new JComboBox(ObjectTypeList));
     OutputDetailsPanel.add((JComboBox)ObjectTypeCBox.elementAt(i), new Rectangle(1,i+1,2,1));
     ((JComboBox)ObjectTypeCBox.elementAt(i)).addActionListener(this);


 
     DataTypeCBox.addElement(new JComboBox(DataTypeList));
     OutputDetailsPanel.add((JComboBox)DataTypeCBox.elementAt(i),new Rectangle(3,i+1,2,1));
     ((JComboBox)DataTypeCBox.elementAt(i)).addActionListener(this);
     ((JComboBox)DataTypeCBox.elementAt(i)).setSelectedIndex(1);

   
     jt = new JTextArea("Description should not be blank");
     jp = new JScrollPane(jt);

    jt.setFont(new Font("Serif",Font.BOLD,14));
    jt.setLineWrap(true);
    jt.setWrapStyleWord(true);
    jp.setPreferredSize(new Dimension (200,50));


     DescriptionTextArea.addElement(jt);

     OutputDetailsPanel.add((JTextArea)DescriptionTextArea.elementAt(i),new Rectangle(5,i+1,3,1));
  }
    int flag = TotalOutputs;
    TotalOutputs = NewTotalOutputs;
    if(NewTotalOutputs > flag)
     {
      UpdateCalled = true;
      UpdatePanel();
      }


 }      // end of UpdatePanel()



void checkNames()
  {
   String str;

   for(int i = 0; i< NewTotalOutputs;i++)  // could have used TotalOutputs also
    {
     str = (i+1) +  "   "  +(String)OutputNames.elementAt(i);
      ((JLabel)NameLabels.elementAt(i)).setText(str);
     }
   }


 public void actionPerformed(ActionEvent ae)
 {

 }

  boolean getifTouched()
  {
    return ifTouched;
  }




// id is the input number
   int getDataType(int id)
    {
     String DataType = "INTEGER";
     DataType = (String)((JComboBox)DataTypeCBox.elementAt(id)).getSelectedItem();

   if(DataType.equals("NO TYPE"))
     return 0;
   else
   if(DataType.equals("INTEGER"))
     return 1;
   else
   if(DataType.equals("FLOAT"))
     return 2;
   else
   if(DataType.equals("DOUBLE"))
     return 3;
   else
   if(DataType.equals("CHAR"))
     return 6;
   else
   if(DataType.equals("BYTE"))
     return 7;
   else
   if(DataType.equals("SIMPLE COMPLEX"))
     return 4;
   else
   if(DataType.equals("DOUBLE COMPLEX"))
     return 5;
   else
     return -1;
     }

  String getDataType_asStr(int id)
  {
  return (String)((JComboBox)DataTypeCBox.elementAt(id)).getSelectedItem();
  }



 
void setDataType(int type, int id)
{
((JComboBox)DataTypeCBox.elementAt(id)).setSelectedIndex(type); 
 } 



   int getObjectType(int id)
   {
    String Objecttype = "SCALAR";

     Objecttype = (String)((JComboBox)ObjectTypeCBox.elementAt(id)).getSelectedItem();
     
   if(Objecttype.equals("SCALAR"))
    return 3;
   else
   if(Objecttype.equals("ARRAY-1D"))
    return 2;
   else
   if(Objecttype.equals("ARRAY-2D"))
    return 1;
   else
   if(Objecttype.equals("STRING"))
    return 6;
   else
   if(Objecttype.equals("SPARSE MATRIX"))
    return 9;
   else
   if(Objecttype.equals("FILE"))
    return 5;
   else
   if(Objecttype.equals("UPF"))
    return 4;
   else
   if(Objecttype.equals("STRING LIST"))
    return 8;
   else
   if(Objecttype.equals("PACKED FILE"))
    return 7;
   else
    return -1;
   }

  String getObjectType_asStr(int id)
  {
  return (String)((JComboBox)ObjectTypeCBox.elementAt(id)).getSelectedItem();
  }









 // id is the no. of Input
  void setObjectType(int type, int id)
  {
  switch(type)
  {

   case 1:
      ((JComboBox)ObjectTypeCBox.elementAt(id)).setSelectedIndex(2);
      break;
   case 2:
      ((JComboBox)ObjectTypeCBox.elementAt(id)).setSelectedIndex(1);
      break;
   case 3:
      ((JComboBox)ObjectTypeCBox.elementAt(id)).setSelectedIndex(0);
      break;
   case 4:
      ((JComboBox)ObjectTypeCBox.elementAt(id)).setSelectedIndex(6);
      break;
   case 5:
      ((JComboBox)ObjectTypeCBox.elementAt(id)).setSelectedIndex(5);
      break;
   case 6:
      ((JComboBox)ObjectTypeCBox.elementAt(id)).setSelectedIndex(3);
      break;
   case 7:
      ((JComboBox)ObjectTypeCBox.elementAt(id)).setSelectedIndex(8);
      break;
   case 8:
      ((JComboBox)ObjectTypeCBox.elementAt(id)).setSelectedIndex(7);
      break;
   case 9:
      ((JComboBox)ObjectTypeCBox.elementAt(id)).setSelectedIndex(4);
      break;
   }

  }


   String getDescription(int id)
   {
    String Description = "\\*  This is default Description for the Input *\\";
    Description = ((JTextArea)DescriptionTextArea.elementAt(id)).getText();
    return Description;
    }


    void setDescription(String desc, int id)
    {
    ((JTextArea)DescriptionTextArea.elementAt(id)).setText(desc);
    }

   int getOutputNumbers()
   {
    return dp.getOutputNumbers();
   }


  java.util.Vector getOutputNames()
  {
   return dp.getOutputNames();
  }

  Objects getOutputObject(int n)
  {
   int Objecttype = getObjectType(n);

    Objects ob = new Objects("Input    1");

   ob.setName((String)OutputNames.elementAt(n));
   ob.setDataType(getDataType(n));
   ob.setObjectType(Objecttype);
   ob.setDesc(getDescription(n));
 
    if(Objecttype == 3)
      ob.setCallObj(new Scalar());
   else
   if(Objecttype == 2)
         ob.setCallObj(new Vector());
   else
   if(Objecttype == 1)
       ob.setCallObj(new Matrix());
   else
   if(Objecttype == 6)
       ob.setCallObj(new NetSolveString());
   else
   if(Objecttype == 9)
          ob.setCallObj(new SparseMatrix());
   else
   if(Objecttype == 5)
        ob.setCallObj(new NetSolveFile());
   else
   if(Objecttype == 4 )
       ob.setCallObj(new NetSolveUPF());
   else
   if(Objecttype == 8)
       ob.setCallObj(new NetSolveStringList());
   else
   if(Objecttype == 7)
       ob.setCallObj(new NetSolvePackedFiles());

   return ob;


    }



  void setOutputObject(Objects ob,int id)
  {
   setDataType(ob.getDataType(),id);
   setObjectType(ob.getObjectType(),id);
   setDescription(ob.getDesc(),id);

  }


















 
} // end of InputPanel Class definition
