/**
* Objects
*
* @version 2.0, 5 April 1998
* @author Zach Eyler-Walker (zwalker@cs.utk.edu)
* 
* @version 1.1, 26 Jan 1998 
* @author Henri Casanova (casanova@cs.utk.edu)
*
**/

public class Objects {

  public static int NETSOLVE_MATRIX        = 1;
  public static int NETSOLVE_VECTOR        = 2;
  public static int NETSOLVE_SCALAR        = 3;
  public static int NETSOLVE_UPF           = 4;
  public static int NETSOLVE_FILE          = 5;
  public static int NETSOLVE_STRING        = 6;
  public static int NETSOLVE_PACKEDFILES   = 7;
  public static int NETSOLVE_STRINGLIST    = 8;
  public static int NETSOLVE_SPARSEMATRIX  = 9;

  public static int NETSOLVE_NOTYPE        = 0;
  public static int NETSOLVE_I             = 1;
  public static int NETSOLVE_S             = 2;
  public static int NETSOLVE_D             = 3;
  public static int NETSOLVE_C             = 4;
  public static int NETSOLVE_Z             = 5;
  public static int NETSOLVE_CHAR          = 6;
  public static int NETSOLVE_B             = 7;

  private static String[] objectTypes = {
    "Unused",
    "Matrix",
    "Vector",
    "Scalar",
    "NetSolveUPF",
    "NetSolveFile",
    "NetSolveString",
    "NetSolvePackedFiles",
    "NetSolveStringList",
    "SparseMatrix"
  };

  private static String[] dataTypes = {
    "NoType",
    "I",
    "S",
    "D",
    "C",
    "Z",
    "CHAR",
    "B"
  };

  private int dataType;
  private int objectType;
  private String name;
  private String description;
  private ObjectType callObj;

  public Objects(String s){
    name = s;
  }

  public Objects(int dt, int ot, String n, String d, ObjectType co)
  {
    dataType = dt;
    objectType = ot;
    name = n;
    description = d;
    callObj = co;
  }

  public static String getObjectTag(int x)
  {
    return objectTypes[x];
  }

  public static String getDataTag(int x)
  {
    return dataTypes[x];
  }

  public void setDataType(int arg)
  {
    dataType = arg;
  }
  
  public int getDataType()
  {
    return dataType;
  }

  public void setObjectType(int arg)
  {
    objectType = arg;
  }



  public int getObjectType()
  {
    return objectType;
  }

  public void setName(String arg)
  {
    name = arg;
  }

  public String getName()
  {
    return name;
  }

  public void setDesc(String arg)
  {
    description = arg;
  }

  public String getDesc()
  {
    return description;
  }

  public void setCallObj(ObjectType arg)
  {
    callObj = arg;
  }

  public ObjectType getCallObj()
  {
    return callObj;
  }
}
