import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.Vector;
//import com.util.myjava.*;  // to import CustomLayout, MovingCanvas, ColorChooser



public class MCSInputPanel extends JPanel
{
 private JLabel TitleLabel;
 InputPanel ip = null;
 private int TotalInputs;
 private int NewTotalInputs;


 private java.util.Vector InputNames; 
  

 java.util.Vector NameLabels;   // just Name and Number
 java.util.Vector SequenceCBox; // Just the Sequence

 private JPanel InputDetailsPanel;
 CustomLayout cl = null;
 boolean UpdateCalled = false;

  public MCSInputPanel(InputPanel ip)
  {
   this.ip = ip;
 
   TitleLabel = new JLabel();
   InputNames = new java.util.Vector();

   NameLabels = new java.util.Vector();
   SequenceCBox = new java.util.Vector();
   

   InputDetailsPanel = new JPanel();
  
   this.setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));


   add(TitleLabel);  // shows Ori Pos ,Input Name and New Position 
   add(new JLabel(" "));
   add(InputDetailsPanel);  // panel thats going to hold stuff


   TitleLabel.setText("Original Positon \t Input Name\t New Postion");
   InputDetailsPanel.setLayout(new GridLayout(TotalInputs,2));
   InputDetailsPanel.setPreferredSize(new Dimension(100,50));   

 
   } // end of MCSInputPanel() Constructor
  
  void UpdatePanel()
  {
   NewTotalInputs = ip.getInputNumbers();
  
   if(NewTotalInputs == 0)
    return;
   InputNames = ip.getInputNames();


   if(NewTotalInputs < 20)
     cl = new CustomLayout(new Dimension(2, 20));  // 20 just to have proper grid size
   else
     cl = new CustomLayout(new Dimension(2, NewTotalInputs));  // else # of inputs to have grid size 

   if(!UpdateCalled)  // means update is not called again
    InputDetailsPanel.setLayout(cl); // if called then dont setLayout
  

  String[]  Sequencestr = new String[NewTotalInputs];


  if(TotalInputs == NewTotalInputs)  // name might differ so check
    checkNames();
  if(TotalInputs > NewTotalInputs)
  {
   InputDetailsPanel.removeAll();
   TotalInputs = 0;
   }
  

   for(int i =0;i<NewTotalInputs;i++)
      Sequencestr[i] = new Integer(i+1).toString();
 
   String str;
 
    for(int i =TotalInputs;i<NewTotalInputs;i++)
    {

     str = (i+1) +  "\t"  +(String)InputNames.elementAt(i);

     NameLabels.addElement(new JLabel(str));
     InputDetailsPanel.add((JLabel)NameLabels.elementAt(i),new Rectangle(0,i,1,1));


     SequenceCBox.addElement(new JComboBox(Sequencestr));
   InputDetailsPanel.add((JComboBox)SequenceCBox.elementAt(i),new Rectangle(1,i,1,1));  
    }   
  
   for(int i = 0;i<TotalInputs;i++)
    for(int j = TotalInputs;j<NewTotalInputs;j++)
     ((JComboBox)SequenceCBox.elementAt(i)).addItem(new Integer(j+1).toString()); 

   int flag = TotalInputs;
   TotalInputs = NewTotalInputs;
 
   if(NewTotalInputs > flag)
   {
     UpdateCalled = true; // just a flag to check if update is called or not
     UpdatePanel();
   }


 }  // end of UpdatePanel()


  void checkNames()
  {
   String str;

   for(int i = 0; i< NewTotalInputs;i++)  // could have used TotalInputs also
    {
     str = (i+1) +  "   "  +(String)InputNames.elementAt(i);
      ((JLabel)NameLabels.elementAt(i)).setText(str);
     }
   }



IOSequence  getInputObjectSequence()
 {
   IOSequence ios = new IOSequence(TotalInputs);
   
 try{
       for(int i=0;i<TotalInputs;i++)
     ios.setElementAt(getSelection(i),i);
     }
   catch (ArrayIndexOutOfBoundsException ae)
    {
    
     System.out.println("ArrayIndexOutOfBoundsException has occured\n");
    }
    
    return ios;
  }

// n is the no. of input for which selection is sort after

  int getSelection(int n)
  {
   int Index = 0;
   Index = Integer.valueOf((String)(((JComboBox)SequenceCBox.elementAt(n)).getSelectedItem())).intValue();
   return Index;
  }

void setInputObjectSequence(IOSequence ios)
  {
  try{
  for (int i = 0;i<ios.getSize();i++)
  {
   ((JComboBox)SequenceCBox.elementAt(i)).setSelectedIndex(ios.getElementAt(i) -1);
  }
 }catch(ArrayIndexOutOfBoundsException ae)
  {
  System.out.println("ArrayIndexOutOfBoundsException Has Occured in setInputObjectSequence\n");

  }

 }



} // end of MCSInputPanel Class
