public class IOSequence {
  private int [] sequence;

  public IOSequence(int size) {
    sequence = new int[size];
    for(int i=0;i<size;i++)
      sequence[i] = i+1;
  }

  public IOSequence(int size, int initialValue) {
    sequence = new int[size];
    for(int i=0;i<size;i++)
      sequence[i] = initialValue;
  }

  public void setElementAt(int val, int idx) {
    if(sequence == null)
      throw new ArrayIndexOutOfBoundsException("NULL sequence");

    sequence[idx] = val;
  }

  public int getElementAt(int idx) {
    if(sequence == null)
      throw new ArrayIndexOutOfBoundsException("NULL sequence");

    return sequence[idx];
  }

  public int getSize()
  {
    return sequence.length;
  }
}
