import java.applet.*;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.filechooser.*;
import java.io.*;
import java.net.*;
//import com.util.myjava.*;  // to import CustomLayout, MovingCanvas,ColorChooser



public class FileHelpMenubar extends JMenuBar implements ActionListener

{
  ButtonPanel bp;
  ProblemChoicePanel pp = null;

  ProblemDescription pd; 
  private ProblemDescription [] pdo = null; 
  PDFParser parser;

  String FileName = null;

  JMenu  FileMenu ;
  JMenuItem New;
  JMenuItem close;
  JMenuItem open;
  JMenuItem exit;
  JMenuItem save;
  JMenuItem saveas;


  JMenu  HelpMenu ;
  JMenuItem about;
  JMenuItem help;
  JMenuItem audioHelp;


  JMenu ToolsMenu;
  JMenuItem color;
  JMenuItem codeVerifier;
  JMenuItem calculator;
   

   JFrame fp;
   JButton Okbtn;
   JComboBox Choices;
    
   boolean ifTouched = false;
   PlayThread pt = null;
   MatlabMerge mm;
   Complexity c;   
   int closeFlag = 0;      
   int saveFlag = 0;

FileHelpMenubar(ButtonPanel bp, ProblemDescription pd)
 {
   this.bp = bp;
   this.pd = pd;
   pt = new PlayThread();  // starts a thread 'll b stoped by exit

   FileMenu = new JMenu("File");
   New = new JMenuItem("New");
   FileMenu.add(New);
 
   open = new JMenuItem("Open");
   FileMenu.add(open);
   save = new JMenuItem("Save");
   FileMenu.add(save);
   saveas = new JMenuItem("Save As");
   FileMenu.add(saveas);
   FileMenu.addSeparator();
   close = new JMenuItem("Close");
   FileMenu.add(close); 
   exit = new JMenuItem("Exit");
   FileMenu.add(exit);

   New.addActionListener(this);
   open.addActionListener(this);
   save.addActionListener(this);
   exit.addActionListener(this);
   saveas.addActionListener(this);
   close.addActionListener(this);
  


   HelpMenu = new JMenu("Help");
   about = new JMenuItem("About");
   HelpMenu.add(about);
   help = new JMenuItem("Help");
   HelpMenu.addSeparator();
   HelpMenu.add(help);
   audioHelp = new JMenuItem("Audio Help");
   HelpMenu.add(audioHelp);


   about.addActionListener(this);
   help.addActionListener(this);
   audioHelp.addActionListener(this);



   ToolsMenu = new JMenu("Tools");
   color = new JMenuItem("Color");
   codeVerifier = new JMenuItem ("Code Verifier");
   calculator = new JMenuItem ("Calculator"); 

   ToolsMenu.add(color);  
   ToolsMenu.add(codeVerifier);  
   ToolsMenu.add(calculator);  

   color.addActionListener(this);
   codeVerifier.addActionListener(this);
   calculator.addActionListener(this);



   add(FileMenu);
   add(HelpMenu);
   add(ToolsMenu);
  

   Choices = new JComboBox();
   parser = new PDFParser();
    
  }
 

  void fillGUIfield(int n)
  {
  // LibDirs are empty as they are stored by same name in pdf
 // so browse LibFile and check for Dir and then store in libdir

   java.util.Enumeration libs =   pdo[n].getLibs();
 
   // clear lib files linkedlist as it contains dirs also
   // then add only the files to libs and dirs to Libdirs

   pdo[n].clearLibs();

   String str = null;
   File f = null;
   while(libs.hasMoreElements())
   {
   str = (String)libs.nextElement();
   System.out.println(str);
   if(!str.endsWith(".a"))
    {pdo[n].addLibdir(str); System.out.println("Yes Direct");}
   else    // add only the files to libs  
    pdo[n].addLib(str);
   }

   bp.fillGUIfield(pdo[n]);  // pass Problemdescriptor
   //pdo = null;

  } // end of fillGUIfield

  void displayChoices()
  {
   fp = new JFrame();
   
   Choices.removeAllItems(); 

   for(int i =0;i<pdo.length;i++)
    Choices.addItem((String) pdo[i].getName());
 
   Okbtn = new JButton("OK");


    Choices.addActionListener(this);
    Okbtn.addActionListener(this);

  Container c = fp.getContentPane();
  c.setLayout(new BoxLayout(c,BoxLayout.Y_AXIS));
  c.add(Choices);
  c.add(Okbtn);

  fp.setSize(new Dimension(300,200)); 
  fp.setVisible(true); 

  }


  public void actionPerformed(ActionEvent ae)

  {
  if(ae.getSource() == Okbtn)
  {
   fp.setVisible(false);
   fillGUIfield(Choices.getSelectedIndex());
    }
  

  if(ae.getSource() == New)
  {
   // save the existing file or not
   int Choice = 0;
   saveFlag = 0;
  
   if(closeFlag==0)
   {
 
   Object[] options = {"Yes, Please","No, Thanks","Cancel"};
  
   if(FileName != null)
   {
   Choice = JOptionPane.showOptionDialog(null,"Do you want to save file\n " + FileName,"Confirmation",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE,null,options,options[2]);
   }
   else
   {
   Choice = JOptionPane.showOptionDialog(null,"Do you want to save file\n " + "Untitled","Confirmation",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE,null,options,options[2]);
   }

   if(Choice == 0) //save
   {
    pd = new ProblemDescription();
    if(FileName != null)
    {
      pd= bp.fillProblemDescription();
      try{
           FileWriter fw = new FileWriter(FileName);
           pd.writeXML(fw);
         }
       catch(IOException e)
       { 
        System.out.println("could not write to " + FileName);
        }
    }
    else
    {
     saveFlag = 1;
     JFileChooser fc = new JFileChooser();
     fc.addChoosableFileFilter(new CustomFileFilter("xmlpdf"));
     int returnval = fc.showSaveDialog(this);
     if(returnval == JFileChooser.APPROVE_OPTION)
      {   
       saveFlag = 0;
       File file = fc.getSelectedFile();
       String extension = Utils.getExtension(file);
       StringBuffer sb = null;
       if(extension == null || !extension.equals(Utils.xmlpdf))
        {
          sb = new StringBuffer(((File)file).toString());
          sb.append(".xmlpdf");
        }
        else
          sb = new StringBuffer(((File)file).toString());
    
        pd= bp.fillProblemDescription();
        FileName = sb.toString();
      try{
           FileWriter fw = new FileWriter(FileName);
           pd.writeXML(fw);
         }
       catch(IOException e)
       {
        saveFlag = 1;
        System.out.println("could not write to " + file);
       }
        
     }   

    } //end of else 
   } // end of save
  }//end of closeFlag
  closeFlag = 0;
  bp.setSelectedComponent(bp.dp);
  bp.setVisible(true);
 
   if(Choice != 2 && saveFlag == 0)
  {
   FileName = null; 
   bp.dp.setDescription("/* This is default Description */");
   bp.dp.setFunction_name("MyProblem ");
   bp.dp.initialiseInputTextField("Input1");
   bp.dp.initialiseOutputTextField("Output1");

   bp.ip.UpdatePanel();
   bp.ip.setDescription("Description should not be blank",0);

   bp.op.UpdatePanel();
   bp.op.setDescription("Description should not be blank",0);

   bp.mcp.UpdatePanel();
   bp.cfp.UpdatePanel();

   bp.detp.setPathName("/bubba/bubba/");
   bp.detp.setLanguage("C");
   bp.detp.setMajor("ROW");
   bp.detp.initialiseMatlabMerge();
   c = new Complexity(1,1);
   bp.detp.setComplexity(c);
   bp.detp.setFunctionNumbers(0);
   bp.detp.setFunctionTextField("");
   bp.detp.setCustomName(null);   

   bp.cp.CodeArea.setText("/** \n write the main() function of the c code here \n for e.g. if the main() function looks like \n main() \n { \n printf(\"Hello World \\n\"); \n } \n write \n printf(\"Hello World\\n\"); \n in this area \n If your code would contain locaal variables and Toolbox Variables for e.g. \n int m; \n m = 3; \n A.rows = m; \n In this code, m is a local variable and A.rows is a ToolBox Variables  **/ \n\n\n ");   
   bp.fdetp.initialiseFileDetailsPanel();   

   bp.mc.delMsgs();
   bp.mc.setVisible(false);
   bp.updateAll();
  }


   } // end of ae.getSource == New

  if(ae.getSource() == close)
  {
   if(closeFlag == 0)
   {
   // save the existing file or not
   int Choice = 0;
   saveFlag = 0;
   Object[] options = {"Yes, Please","No, Thanks","Cancel"};

   if(FileName != null)
   {
   Choice = JOptionPane.showOptionDialog(null,"Do you want to save file\n " + FileName,"Confirmation",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE,null,options,options[2]);
   }
   else
   {
   Choice = JOptionPane.showOptionDialog(null,"Do you want to save file\n " + "Untitled","Confirmation",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE,null,options,options[2]);
   }
    
   if(Choice == 0) //save
   {
    pd = new ProblemDescription();
    if(FileName != null)
    {
      pd= bp.fillProblemDescription();
      try{
           FileWriter fw = new FileWriter(FileName);
           pd.writeXML(fw);
         }
       catch(IOException e)
       {
        System.out.println("could not write to " + FileName);
        }
    }
    else
    {
     saveFlag = 1;
     JFileChooser fc = new JFileChooser();
     fc.addChoosableFileFilter(new CustomFileFilter("xmlpdf"));
     int returnval = fc.showSaveDialog(this);
     if(returnval == JFileChooser.APPROVE_OPTION)
      {
       saveFlag = 0;
       File file = fc.getSelectedFile();
       String extension = Utils.getExtension(file);
       StringBuffer sb = null;
       if(extension == null || !extension.equals(Utils.xmlpdf))
        { 
          sb = new StringBuffer(((File)file).toString());
          sb.append(".xmlpdf");
        }
        else
          sb = new StringBuffer(((File)file).toString());
    
        pd= bp.fillProblemDescription();
        FileName = sb.toString();
      try{
           FileWriter fw = new FileWriter(FileName);
           pd.writeXML(fw);
         }
       catch(IOException e)
       {
        saveFlag = 1;
        System.out.println("could not write to " + file);
       }
          
     }
          
    } //end of else
   } // end of save

   if(Choice !=2 && saveFlag == 0)
   {
    FileName = null; 
    bp.setVisible(false);
    closeFlag = 1;
   }
   } //end of closeFlag
   } // end of ae.getSource == close 

 if(ae.getSource() == open)
 {
  int Choice = -1; 
  saveFlag = 0;

  if(closeFlag == 0)
  {
   Object[] options = {"Yes, Please","No, Thanks","Cancel"};
      
           
   if(FileName != null)
   {
   Choice = JOptionPane.showOptionDialog(null,"Do you want to save file\n " + FileName,"Confirmation",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE,null,options,options[2]);
   }
   else
   {
   Choice = JOptionPane.showOptionDialog(null,"Do you want to save file\n " + "Untitled","Confirmation",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE,null,options,options[2]); 
   }
   if(Choice == 0) //save
   {
    pd = new ProblemDescription();
    if(FileName != null)
    {
      pd= bp.fillProblemDescription();
      try{
           FileWriter fw = new FileWriter(FileName);
           pd.writeXML(fw);
         }
       catch(IOException e)
       {
        System.out.println("could not write to " + FileName);
        }
    }
    else
    {
     saveFlag = 1;
     JFileChooser fc = new JFileChooser();
     fc.addChoosableFileFilter(new CustomFileFilter("xmlpdf"));
     int returnval = fc.showSaveDialog(this);
     if(returnval == JFileChooser.APPROVE_OPTION)
      {
       saveFlag = 0;
       File file = fc.getSelectedFile();
       String extension = Utils.getExtension(file);
       StringBuffer sb = null;
       if(extension == null || !extension.equals(Utils.xmlpdf))
        {
          sb = new StringBuffer(((File)file).toString());
          sb.append(".xmlpdf");
        }
        else
          sb = new StringBuffer(((File)file).toString());
     
        pd= bp.fillProblemDescription();  
        FileName = sb.toString();
      try{
           FileWriter fw = new FileWriter(FileName);
           pd.writeXML(fw);
         }
       catch(IOException e)
       {
        saveFlag = 1;
        System.out.println("could not write to " + file);
       } 
          
     }
         
    } //end of else
   } // end of save
  }//end of closeFlag

  

   if(Choice != 2 && saveFlag == 0)
  {
   JFileChooser fc = new JFileChooser();
   String errMsg = null;
    fc.addChoosableFileFilter(new CustomFileFilter("xmlpdf"));// filter xml files
    int returnval = fc.showOpenDialog(this); // show the open dialog box
    if(returnval == JFileChooser.APPROVE_OPTION)
     {
       File file = fc.getSelectedFile();  // the file that is opened
       FileName = ((File)file).toString();
       try{
        parser = new PDFParser();
        pdo = null;
        pdo = parser.parseFile(FileName); //pdo is an array of Prob Descp
        }
       catch(PDFParsingException pe)
       { 
        errMsg = pe.getMessage();
        System.err.println(errMsg);
   
        //System.exit(1);
       }
       catch(java.io.IOException ie)
       {
        System.err.println("Error Opening file: "+ ie.getMessage());
        System.exit(1);
       }
       if(pdo != null)  // if no parsing exception has occured
        {if(pdo.length == 1)   // if just one problem in the file
           { 
            fillGUIfield(0);
            closeFlag = 0;
            bp.setSelectedComponent(bp.dp);
            bp.setVisible(true);
            bp.updateAll();
           }
         else
           displayChoices();  // if more than 1 problem in the file
        }
        else
         {
       // could not parse and some error in file so display to user
         System.out.println("Please check file");
         JOptionPane.showMessageDialog(null,"The File "+ FileName+ " has error(s)\n "+ errMsg+ " So can't open it ");
           }
     }
  } 
 

 }  // end of ae.source == open

 if(ae.getSource() == save)
  {
  if (closeFlag == 0) //bp is not closed
  { 
    boolean ok = true;
    bp.updateAll();
    bp.allComplete();
    for(int i = 0;i<7;i++)
     if(bp.getBackgroundAt(i).equals(new java.awt.Color(255,100,100)))
       {
        JOptionPane.showMessageDialog(null,"Please Check panel "+(i+1));
        ok = false;
        break;
       }
   if(ok)
   {
    if(FileName == null)  // getFileName
    {
     JFileChooser fc = new JFileChooser();
     fc.addChoosableFileFilter(new CustomFileFilter("xmlpdf"));
     int returnval = fc.showSaveDialog(this);
     if(returnval == JFileChooser.APPROVE_OPTION)
      {
       File file = fc.getSelectedFile();
       String extension = Utils.getExtension(file);
       StringBuffer sb = null;
       if(extension == null || !extension.equals(Utils.xmlpdf))
        {
          sb = new StringBuffer(((File)file).toString());
          sb.append(".xmlpdf");
        }
        else
          sb = new StringBuffer(((File)file).toString());

        pd= bp.fillProblemDescription();      
        FileName = sb.toString();
      try{
           FileWriter fw = new FileWriter(FileName);
           pd.writeXML(fw);
         }
       catch(IOException e)
       {
        System.out.println("could not write to " + file);}
        }
     }
   else   // FileName is not null
     {
       pd= bp.fillProblemDescription();
      try{
           FileWriter fw = new FileWriter(FileName);
           pd.writeXML(fw);
         }
       catch(IOException e)
       {
        System.out.println("could not write to " + FileName);
        }
     }
   }  // end of if OK
 } //end of closeFlag
}   // end of if ae.getSource == save


   if(ae.getSource() == saveas)
   {
   if(closeFlag == 0) //bp is not closed
   {
    boolean ok = true;
    bp.updateAll();
    bp.allComplete();
    for(int i = 0;i<8;i++)
     if(bp.getBackgroundAt(i).equals(new java.awt.Color(255,100,100)))
       {
        JOptionPane.showMessageDialog(null,"Please Check panel "+(i+1));
        ok = false;
        break;
       }      
   if(ok)
   {
    JFileChooser fc = new JFileChooser();
    fc.addChoosableFileFilter(new CustomFileFilter("xmlpdf"));
    fc.addChoosableFileFilter(new CustomFileFilter("nspdf"));
    int returnval = fc.showSaveDialog(this);
    if(returnval == JFileChooser.APPROVE_OPTION)
     {
       File file = fc.getSelectedFile();
       System.out.println("des " + fc.getFileFilter().getDescription());
      
       String des = fc.getFileFilter().getDescription();

       String extension = Utils.getExtension(file);
       
       StringBuffer sb = null; 
       if(extension == null)
        {
         sb = new StringBuffer(((File)file).toString());
          if(des.equals("xmlpdf Files"))
            extension = "xmlpdf";
          else
            extension = "nspdf";
          sb.append("." + extension);
        }
        else
          sb = new StringBuffer(((File)file).toString());

        pd= bp.fillProblemDescription();       
       FileName = sb.toString(); 

      try{
           FileWriter fw = new FileWriter(FileName);

          if(extension.equals("nspdf"))
            {
            System.out.println("in nspdf " +FileName);
            pd.writeOLD(fw,FileName);

            //changing current FileName to .xmlpdf
            int i;
            char ch[] = FileName.toCharArray();
            StringBuffer sb_temp = new StringBuffer("");
            
            for(i=0;i<=(FileName.length()-6);i++)
            sb_temp.append(ch[i]);

            sb_temp.append("xmlpdf");
            FileName = sb_temp.toString(); 

            }
          if(extension.equals("xmlpdf"))
           pd.writeXML(fw);
         }
       catch(IOException e)
       {
        System.out.println("could not write to " + file);}
        }
   } // end of if OK
  } // end of closeFlag
  }

   if(ae.getSource() == exit)
    {
     pt.stop();  // stops the play thread
     System.exit(0);
     }

   if(ae.getSource() == about)
    {
    JOptionPane.showMessageDialog(null,"This is XML PDGUI \nVersion 0.1 ");
    }

   if(ae.getSource() == color)
    {
 /*    ColorChooser cf = new ColorChooser(bp.getSelectedComponent());
     cf.addWindowListener(new WindowAdapter() {
           public void windowClosing(WindowEvent e){}
          });  
     cf.pack();
     cf.setVisible(true); */
    }

  if(ae.getSource() == audioHelp)
  {
     switch(bp.getSelectedIndex())
      {
       case 0:
            System.out.println("Description panel");
            pt.play("spacemusic.au");  // play the clip once
            break;
       case 1:
            System.out.println("Input panel");
            break;
       case 2:
            System.out.println("Output panel");
            break;
       case 3:
            System.out.println("Details panel");
            break;
       case 4:
             System.out.println("Code panel");
            break;
       case 5:
            System.out.println("MCallingSequence panel");
            break;
       case 6:
            System.out.println("CFCallingSequence panel");
            break;
      }
  }  // end of audioHelp

  if(ae.getSource() == help )
   {
   JOptionPane.showMessageDialog(null,"This Feature Is Not Implemented\n ");
   }


  } // end of actionPerformed()



} // end of class FileHelpMenubar
