// This panel contains 

 /********************************************************************
     
   1. Funtion Names
   2. Complexity
   3. Language
   4. Major
   5. Custom 
   6. Matlab Merge 
 

 **********************************************************************/

  import java.awt.*;
  import java.awt.event.*;
  import javax.swing.*;
  import javax.swing.filechooser.*;
  import java.io.*;


  public class DetailsPanel extends JPanel implements ActionListener
  {
   private JLabel FunctionLabel,dummy1Label;
   private JLabel ComplexityLabel,aLabel,bLabel,dummy2Label;
   private JLabel LanguageLabel,MajorLabel;

   private JTextField FunctionTextField;
   private JTextField aTextField,bTextField;

 
   private JRadioButton CLanguageRBtn,FLanguageRBtn;
   private JRadioButton RowRBtn,ColumnRBtn;


   private JLabel PathNameLabel;
   private JTextField PathNameTextField;
   private JLabel dummy3Label;

   private ButtonGroup LanguageRGrp;
   private ButtonGroup MajorRGrp;

   private JLabel mmLabel;  // MatlabMerge label
   private JTextField mmObj1Tfield;
   private JTextField mmObj2Tfield;

      
   private int FunctionNumbers;
   private java.util.Vector FunctionNames;
    
   private JComboBox CustomCBox;
   private JTextField CustomTextField;
   private String CustomFunctionList[] = {"No Custom Function","Scalapack","Iterative Solver","Globus","Other"};

   boolean ifTouched = false;


public  DetailsPanel()
   {
   setLayout(new GridLayout(26,3));
   setMaximumSize(new Dimension (750,750));
   setSize(getMaximumSize());

   FunctionNames = new java.util.Vector();

    FunctionLabel = new JLabel("Function.. Comma Separated");
   dummy1Label = new JLabel("");
   ComplexityLabel = new JLabel("Complexity             a");  
   aLabel = new JLabel("");
   bLabel = new JLabel("");
   dummy2Label = new JLabel(" ( C = a X n^b )       b");
   LanguageLabel = new JLabel("Language");
   MajorLabel = new JLabel("Major");
   PathNameLabel = new JLabel("Path Name");
   dummy3Label = new JLabel(" ");
 

  
  FunctionTextField = new JTextField();
  FunctionTextField.setFont(new Font("Serif",Font.BOLD,14));

 
  aTextField = new JTextField("1");
  aTextField.setFont(new Font("Serif",Font.BOLD,14));
  bTextField = new JTextField("1");
  bTextField.setFont(new Font("Serif",Font.BOLD,14));
  PathNameTextField = new JTextField("/bubba/bubba/");
  PathNameTextField.setFont(new Font("Serif",Font.BOLD,14));
 
  
 
  CLanguageRBtn = new JRadioButton("C");
  CLanguageRBtn.setSelected(true);  
  FLanguageRBtn = new JRadioButton("FORTRAN");
  RowRBtn = new JRadioButton("Row");
  RowRBtn.setSelected(true);
  ColumnRBtn = new JRadioButton("Column");

   mmLabel  = new JLabel("Matlab Merge");  // MatlabMerge label
   mmObj1Tfield = new JTextField();
   mmObj2Tfield = new JTextField();
   mmObj1Tfield.setFont(new Font("Serif",Font.BOLD,14));
   mmObj2Tfield.setFont(new Font("Serif",Font.BOLD,14));


  CustomCBox = new JComboBox(CustomFunctionList);
  CustomTextField = new JTextField("No Custom Function");
  CustomTextField.setFont(new Font("Serif",Font.BOLD,14));
  

 add(new JLabel());
 add(new JLabel("Details Panel"));
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());

 add(FunctionLabel);
 add(FunctionTextField);
 add(dummy1Label);

 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 

 add(ComplexityLabel);
 add(aTextField);
 add(aLabel);
 
 add(dummy2Label);
 add(bTextField);
 add(bLabel);

 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 

 add(LanguageLabel);
 LanguageRGrp = new ButtonGroup();
 LanguageRGrp.add(CLanguageRBtn);
 LanguageRGrp.add(FLanguageRBtn);
 add(CLanguageRBtn);
 add(FLanguageRBtn);

 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());


 add(MajorLabel);
 MajorRGrp = new ButtonGroup();
 MajorRGrp.add(RowRBtn);
 MajorRGrp.add(ColumnRBtn);
 add(RowRBtn);
 add(ColumnRBtn);


 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 
 add(mmLabel);  // MatlabMerge label
 add(new JLabel());
 add(new JLabel());

 add(new JLabel("Object 1"));
 add(mmObj1Tfield);
 add(new JLabel());

 add(new JLabel("Object 2"));
 add(mmObj2Tfield);
 add(new JLabel());
 
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 
 add(PathNameLabel);
 add(PathNameTextField);
 add(dummy3Label);


 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 
 add(new JLabel("Custom Name"));
 add(CustomCBox);
 add(CustomTextField); 
 CustomTextField.setVisible(false);

 CustomCBox.addActionListener(this);

 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 add(new JLabel());
 


 setMaximumSize(new Dimension(770,700));
 setPreferredSize(getMaximumSize()); 
 setSize(getMaximumSize());

  } // end of DetailsPanel() constructor



 public void actionPerformed(ActionEvent ae)
 {

if(ae.getSource() == CustomCBox)
  {
    if(((String)CustomCBox.getSelectedItem()).equals("Other"))
     {
      CustomTextField.setVisible(true);
      CustomTextField.setText("");
      }
    else
      {
        CustomTextField.setVisible(false);
      CustomTextField.setText((String)CustomCBox.getSelectedItem());
      }
  }

 } // end of actionPerformed()


String getPathName()
 {
  return PathNameTextField.getText();
 } 

void setPathName(String path)
 {
  PathNameTextField.setText(path);
 }


String getLanguage()
 {
  String lan = "C";
  
  if(CLanguageRBtn.isSelected() == true)   
    lan = "C";
  else
    lan = "FORTRAN";

  return lan;
  }

void setLanguage(String lan)
 {

 if(lan.equalsIgnoreCase("C"))
    CLanguageRBtn.setSelected(true);
 else
   if(lan.equalsIgnoreCase("FORTRAN"))
    FLanguageRBtn.setSelected(true);

  }


String getMajor()
 {
  String maj = "ROW";
  
  if(RowRBtn.isSelected() == true)   
    maj= "ROW";
  else
    maj = "COL";

  return maj;
  }

void setMajor(String maj)
 {
  if(maj.equalsIgnoreCase("ROW"))
    RowRBtn.setSelected(true);
  else
   if(maj.equalsIgnoreCase("COL"))
    ColumnRBtn.setSelected(true); 
  }


 Complexity getComplexity()
  {
   Complexity c = new Complexity(1,1);
   // set A
   c.setA(getA());
   // set B 
   c.setB(getB());
   return c;
  }
 
int getA()
  {
  try{
    if(aTextField.getText().equals(""))
     return 0;
     return Integer.valueOf(aTextField.getText()).intValue();
     }
  catch(NumberFormatException e)
    {
    return 0;
    }
  }

int getB()
  {
  try{
    if(bTextField.getText().equals(""))
     return 0;
     return Integer.valueOf(bTextField.getText()).intValue();
     }
  catch(NumberFormatException e)
    {
    return 0;
    }
  }

  void setComplexity(Complexity c)
  {
   aTextField.setText((new Integer(c.getA())).toString());
   bTextField.setText((new Integer(c.getB())).toString());
  } 
   
 MatlabMerge getMatlabMerge()
 {
  int one = 0,two = 0;
  MatlabMerge mm = new MatlabMerge(one,two);
  one = getmmObj1();
  two = getmmObj2();

// if user didnt enter anything in mm object field then one or two is -1 thus
  // return null

  if(one == -1 || two == -1)
   return null;

    mm.setFirstObjectNum(one);
    mm.setSecondObjectNum(two);

  return mm;

  }

 void  setMatlabMerge(MatlabMerge mm)
 {
  if(mm != null)
  {
  mmObj1Tfield.setText((new Integer(mm.getFirstObjectNum())).toString());
  mmObj2Tfield.setText((new Integer(mm.getSecondObjectNum())).toString());
  }
 }

 void initialiseMatlabMerge()
 {
 mmObj1Tfield.setText("");
 mmObj2Tfield.setText("");
 }

int getmmObj1()
  {
  try{
    if(mmObj1Tfield.getText().equals(""))
     return -1;  // to flag that the user has not entered nething 
     return Integer.valueOf(mmObj1Tfield.getText()).intValue();
     }
  catch(NumberFormatException e)
    {
    return 0;  // means user entered some non interger value
    }
  }

int getmmObj2()
  {
  try{
    if(mmObj2Tfield.getText().equals(""))
     return -1;  // to flag that the user has not entered nething 
     return Integer.valueOf(mmObj2Tfield.getText()).intValue();
     }
  catch(NumberFormatException e)
    {
    return 0;
    }
  }




// Function related methods
 
 int getFunctionNumbers()
 {
  String in = FunctionTextField.getText();
  if(in.equals(""))
   {
    FunctionNames = null;
    FunctionNumbers = 0;
    return 0; 
   }
  int Count = 1;
  int startIndex = 0;
  java.util.Vector Names = new java.util.Vector();

  
 if(in.lastIndexOf(',') == (in.length()-1))
  {
    String newin = in.substring(0,in.length()-1);
    in = newin;
  }

  for(int i = 0;i<in.length();i++)
   {
     if(in.charAt(i) == ',')
      {
       Names.addElement(in.substring(startIndex,i));
       startIndex = i+1;
       Count++;
      }
     if(i == in.length()-1)
      Names.addElement(in.substring(startIndex));
    }
  FunctionNames = Names;
  FunctionNumbers = Count;
  return Count;
 }

 void setFunctionNumbers(int n)
 {
  FunctionNumbers = n;
 }
 
java.util.Vector getFunctionNames()
  {
   return FunctionNames;
   }

 String getFunctionName(int n)
 {
  // n should be less than FunctionNumbers;

  return ((String)FunctionNames.elementAt(n));
   
 }

  void setFunctionName(java.util.Enumeration names)
  {
   String str;
   int i = 0;
   while(names.hasMoreElements())
   {
    str = (String)names.nextElement();
     if(i ==0)
        FunctionTextField.setText(str);
     else
        FunctionTextField.setText(FunctionTextField.getText()+","+str);
     
     FunctionNames.insertElementAt(str,i);
    i++;
   }

  } // end of setFunctionName



 String getCustomName()
 {
   if(CustomTextField.getText().equalsIgnoreCase("No Custom Function"))
     return null;
   else
     return CustomTextField.getText();
 }


  void setCustomName(String Cus)
  {
  boolean flag = false;
  if(Cus != null)
  { 
  for(int i =0;i<4;i++)
  {
   if(Cus.equalsIgnoreCase(CustomFunctionList[i]))
   {
   CustomCBox.setSelectedIndex(i); 
   CustomTextField.setVisible(false);
   flag = true;
   break;
   }
  

  }
  if(flag == false)
     {
     CustomTextField.setVisible(true);
     CustomCBox.setSelectedIndex(CustomCBox.getItemCount()-1);
     CustomTextField.setText(Cus);

     }
 }  // end of if Cus != null

 else
  {
   CustomCBox.setSelectedIndex(0);
  }

  } // end of void setCustomName

void setFunctionTextField(String s)
{
 FunctionTextField.setText(s);
}


} // end of DetailsPanel Class

