import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.util.*;
//import com.util.myjava.*;  // for Moving Canvas


public class DescriptionPanel extends JPanel 
{

private JLabel Prob_NameLabel;
private JTextField Prob_NameTextField; 
private JLabel Prob_NameExampleLabel ;
private JLabel DescLabel;
private JTextArea TextArea;
private JScrollPane areaScrollPane;
 
private JLabel InputLabel;
private JTextField InputTextField = null;
private JLabel Input_ExampleLabel;


private JLabel OutputLabel;
private JTextField OutputTextField;
private JLabel Output_ExampleLabel;

private int InputNumbers;
private int OutputNumbers;
private java.util.Vector InputNames;
private java.util.Vector OutputNames;
public  boolean isError = false;
MovingCanvas mc;

 DescriptionPanel()
{ 
  mc = new MovingCanvas("",new Dimension(250,25),this.getSize().width/2,10);
   mc.setFont(new Font("Serif",Font.BOLD,14));

    Prob_NameLabel = new JLabel("Program  Name (Complusory):");
    Prob_NameLabel.setForeground(Color.red);
    Prob_NameTextField = new JTextField("MyProblem "); 
    Prob_NameTextField.setSize(new Dimension(Prob_NameTextField.getSize().width,40));
    Prob_NameTextField.setMaximumSize(new Dimension(Prob_NameTextField.getMaximumSize().width,40));
    Prob_NameExampleLabel = new JLabel("e.g: Iterative_Solver");
    Prob_NameExampleLabel.setForeground(Color.red);

    DescLabel = new JLabel("Problem Description");
    DescLabel.setForeground(Color.red);
    TextArea = new JTextArea("/* This is default Description */");
    TextArea.setSize(new Dimension(TextArea.getSize().width,100));
    TextArea.setMaximumSize(new Dimension(TextArea.getMaximumSize().width,100));
    areaScrollPane = new JScrollPane(TextArea);
    areaScrollPane.setMaximumSize(new Dimension (TextArea.getMaximumSize().width,450)); 
    InputLabel = new JLabel("Comma Seperated Inputs(Atleast 1) :");
    InputLabel.setForeground(Color.red);
    InputTextField = new JTextField("Input1",10); 
    InputTextField.setSize(new Dimension(InputTextField.getSize().width,40));
    InputTextField.setMaximumSize(new Dimension(InputTextField.getMaximumSize().width,40));
    Input_ExampleLabel = new JLabel("e.g: Input#1,Input#2....");
    Input_ExampleLabel.setForeground(Color.red);


    OutputLabel = new JLabel("Comma Seperated Outputs(Atleast 1) :");
    OutputLabel.setForeground(Color.red);
    OutputTextField = new JTextField("Output1",10); 
    OutputTextField.setSize(new Dimension(OutputTextField.getSize().width,40));
    OutputTextField.setMaximumSize(new Dimension(OutputTextField.getMaximumSize().width,40));
    Output_ExampleLabel = new JLabel("e.g: Output#1,Output#2....");
    Output_ExampleLabel.setForeground(Color.red);

    InputNames = new java.util.Vector();
    OutputNames = new java.util.Vector();

    this.setForeground(Color.red);
    this.setBackground(Color.orange);
 

    BoxLayout bl = new BoxLayout(this,BoxLayout.Y_AXIS);
    this.setLayout(bl);

    TextArea.setFont(new Font("Serif",Font.BOLD,14));
    TextArea.setLineWrap(true);
    TextArea.setWrapStyleWord(true);


//    areaScrollPane.setPreferredSize(new Dimension (800,250));

    Prob_NameTextField.setFont(new Font("Serif",Font.BOLD,14));
    InputTextField.setFont(new Font("Serif",Font.BOLD,14));
    OutputTextField.setFont(new Font("Serif",Font.BOLD,14));
 

    add(Prob_NameLabel);
    add(Prob_NameTextField);
    add(Prob_NameExampleLabel);
    add(DescLabel);

    add(areaScrollPane);


    add(InputLabel);
    add(InputTextField);
    add(Input_ExampleLabel);

    add(OutputLabel);
    add(OutputTextField);
    add(Output_ExampleLabel);
//    add(mc); 
 
  }  // end of DescriptionPanel() constructor


  String getDescription()
   {
     return TextArea.getText();
   }

  void setDescription(String desc)
   {
     TextArea.setText(desc);
     //System.out.println("TA max "+ TextArea.getMaximumSize());
     //System.out.println("TA min "+ TextArea.getMinimumSize());
     //System.out.println("TA size "+ TextArea.getSize());
   }

  String getFunction_name()
   {
    return Prob_NameTextField.getText();
   }

  void setFunction_name(String name)
   {
    Prob_NameTextField.setText(name);
     //System.out.println(" max "+ Prob_NameTextField.getMaximumSize());
     //System.out.println(" min "+ Prob_NameTextField.getMinimumSize());
     //System.out.println(" size "+ Prob_NameTextField.getSize());
   }



  int getInputNumbers()
   {
    String in = InputTextField.getText();
    if(in.equals(""))
     return 0; 
    int Count = 1;
    int startIndex = 0; 
    java.util.Vector Names = new java.util.Vector();
  

   if(in.lastIndexOf(',') == (in.length()-1))
    {
     String newin = in.substring(0,in.length()-1); 
     in = newin;
    }     

   for(int i = 0;i<in.length();i++)
    {
     if(in.charAt(i) == ',')
      {
       Names.addElement(in.substring(startIndex,i));
       startIndex = i+1;
       Count++;
      } 
       if(i == in.length()-1)
       Names.addElement(in.substring(startIndex));
    }
     InputNames = Names; 
     InputNumbers = Count; 
  
   return Count;
  }    

int getOutputNumbers()
 {
  String in = OutputTextField.getText();
    if(in.equals(""))
     return 0; 
  int Count = 1;
  int startIndex = 0;
  java.util.Vector Names = new java.util.Vector();


  if(in.lastIndexOf(',') == (in.length()-1))
  {
    String newin = in.substring(0,in.length()-1);
    in = newin;
  }

  for(int i = 0;i<in.length();i++)
   {
     if(in.charAt(i) == ',')
     {
       Names.addElement(in.substring(startIndex,i));
       startIndex = i+1;
      Count++;
     }
     if(i == in.length()-1)
      Names.addElement(in.substring(startIndex));


   }
  
  OutputNames = Names;
  OutputNumbers = Count; 
  return Count;
 }

java.util.Vector getInputNames()
 {
  return InputNames;
 }

java.util.Vector getOutputNames()
 {
  return OutputNames;
 }

void setInputTextField(ProblemDescription pd)
{
  InputNumbers = pd.numInputObjects();
    
  InputTextField.setText("");
 
  for(int i = 0; i < InputNumbers;i++)
   {
  if(i == InputNumbers-1) 
   InputTextField.setText(InputTextField.getText()+ pd.getInputObject(i).getName());
 else
   InputTextField.setText(InputTextField.getText()+ pd.getInputObject(i).getName() + ",");
   }
  


}   

void setOutputTextField(ProblemDescription pd)
{
  OutputNumbers = pd.numOutputObjects();

  OutputTextField.setText("");

  for(int i = 0; i < OutputNumbers;i++)
   {
  if(i == OutputNumbers-1)
   OutputTextField.setText(OutputTextField.getText()+ pd.getOutputObject(i).getName());
 else
   OutputTextField.setText(OutputTextField.getText()+ pd.getOutputObject(i).getName() + ",");
   }

}

void initialiseInputTextField(String s)
{
 InputTextField.setText(s);
}

void initialiseOutputTextField(String s)
{
 OutputTextField.setText(s);
}


} // end of class DescriptionPanel
