/*****************************************************************/
/*      mxproberequest.c                                         */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"
#include <signal.h>

/*
 *  probe for a request
 */
void mxProbeRequest(int nlhs,mxArray *plhs[],int nrhs,mxArray **prhs)
{
  int request_id;
  NS_RequestDesc *rd,*tmp;
  int *input_allocated;
  int i,status;
  int elapsed;


  if (nrhs != 1)
  {
    mexPrintf("Usage: [status] = netsolve_nb('probe',<request_id>)\n");
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    ns_errno = NetSolveBadValues;
    return;
  }

  if (nlhs != 1)
  {
    mexPrintf("Usage: [status] = netsolve_nb('probe',<requestID>)\n");
    ns_errno = NetSolveBadValues;
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL);
    return;
  }

  request_id = (int)(mxGetPr(prhs[0])[0]);
  if ((request_id < 0)||(request_id > NB_MAX_REQUESTS))
  {
    mexPrintf("Invalid request ID\n");
    ns_errno = NetSolveInvalidRequestID;
    plhs[0] = mxCreateDoubleMatrix(0,0,mxREAL);
    mxGetPr(plhs[0])[0] = (double)(-1);
    return;
  }

  /* Find the request_descriptor */
  rd = requests[request_id];
  input_allocated = input_allocateds[request_id];

  if (rd == NULL)
  {
    ns_errno = NetSolveInvalidRequestID;
    mexPrintf("Invalid request ID\n");
    plhs[0] = mxCreateDoubleMatrix(0,0,mxREAL);
    mxGetPr(plhs[0])[0] = (double)(-1);
    return;
  }


  tmp = rd;
  status = netsolveProbeRequest(NS_NOASSIGNMENT, &rd);
  if (tmp != rd)
  {
    requests[request_id] = rd;
    mxMakeRequestDescPersistent(rd,input_allocateds[request_id]);
  }
  
  if (status == 1)
  {
    mexPrintf("Result available\n");
    /* Make the objects persistents (their data)*/
    for (i=0;i<rd->pd->nb_output_objects;i++)
      mexMakeObjectPersistent(rd->pd->output_objects[i],1);
    plhs[0] = mxCreateDoubleMatrix(1,1,mxREAL);
    mxGetPr(plhs[0])[0] = (double)(1);
  }

  if (ns_errno == NetSolveNotReady)
  {
    mexPrintf("Result not yet available\n");
    plhs[0] = mxCreateDoubleMatrix(1,1,mxREAL);
    mxGetPr(plhs[0])[0] = (double)(0);
    return;
  }

  /* Error */
  
  if (status == -1)
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    free(input_allocated);
    input_allocateds[request_id] = NULL;
    freeProblemDesc(rd->pd);
    freeRequestDesc(rd);
    requests[request_id] = NULL;
    plhs[0] = mxCreateDoubleMatrix(1,1,mxREAL);
    mxGetPr(plhs[0])[0] = (double)(-1);
    return;
  }

  return;
}
