/*****************************************************************/
/*      mxnetsolve_errmeg.c                                       */
/*      Henri Casanova          				 */
/*****************************************************************/

#include "mex.h"
#include "core.h"

/*
 * returns the latest ns_errno
 */
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  mxArray *globalnserrno;
  int i;

  if ((nlhs != 1)||(nrhs != 1))
  {
    mexPrintf("Usage: msg = netsolve_errmsg(errcode)\n");
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL); 
    return;
  }

  globalnserrno = mexGetArray("global_ns_errno","base");
  if (globalnserrno == NULL) 
    ns_errno = NetSolveOK;
  else
    ns_errno = (int)(mxGetPr(globalnserrno)[0]);  

  plhs[0] = mxCreateString(netsolveErrorMessage(ns_errno));
  return; 
}
