/*****************************************************************/
/*      mxnetsolve_err.c                                         */
/*      Henri Casanova          				 */
/*****************************************************************/

#include "mex.h"
#include "core.h"

/*
 * returns the latest ns_errno
 */
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  mxArray *globalnserrno;
  int i;

  if ((nlhs != 1)||(nrhs > 0))
  {
    mexPrintf("Usage: x = netsolve_err\n");
    for (i=0;i<nlhs;i++)
      plhs[i] = mxCreateDoubleMatrix(0,0,mxREAL); 
    return;
  }

  plhs[0] = mxCreateDoubleMatrix(1,1,mxREAL);

  globalnserrno = mexGetArray("global_ns_errno","base");
  if (globalnserrno == NULL) 
    mxGetPr(plhs[0])[0] = (double)NetSolveOK;
  else
    mxGetPr(plhs[0])[0] = mxGetPr(globalnserrno)[0];
  return; 
}
