/*****************************************************************/
/*      mxdisplayrequeststatus.c                                 */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"
#include <signal.h>
#include <time.h>

/*
 * Displays the Pending requests
 */
void mxDisplayRequestStatus()
{
  int k;
 
  mexPrintf("--- NetSolve: pending requests ---\n");
  for (k=0;k<NB_MAX_REQUESTS;k++)
  {
    if (requests[k] == NULL)
      continue;
    mexPrintf("Requests #%d: ",k);
    mxDisplayRequest(requests[k]);
  }
  if (k == 0)
    mexPrintf("none\n");
  ns_errno = NetSolveOK;
  return;
}

/*
 * Display a request
 */
void mxDisplayRequest(NS_RequestDesc *r)
{
  time_t now;
  int runningfor;
  int status;
 
  mexPrintf("'%s', submitted to %s (%u.%u.%u.%u)\n",
            r->pd->nickname,r->hostname,
            BYTE(&(r->IPaddr),0),
            BYTE(&(r->IPaddr),1),
            BYTE(&(r->IPaddr),2),
            BYTE(&(r->IPaddr),3));

  time(&now);
  runningfor = (int)now - (int)(r->start_time);
  mexPrintf("\twas started %d seconds ago.\n",runningfor);
  status = netsolveProbeRequest(NS_NOASSIGNMENT, &r);
  mexPrintf("netsolveProbeRequest returned: %d, ns_errno = %d\n",
                   status,ns_errno);
  if (status == 1)
  {
    mexPrintf("\tCompleted\n");
    return;
  }
  if (ns_errno == NetSolveNotReady)
    mexPrintf("\tStill pending\n");
  else
    mexPrintf("\tFailed: %s\n",ns_errno);
  ns_errno = NetSolveOK;
  return;  
}
