/*****************************************************************/
/*      mxdisplayproblemdesc.c                                   */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"

/*
 * Displays the a problem description
 */
void mxDisplayProblemDesc(char *s)
{
  NS_ProblemDesc *pd;
  int status;
  int i;
  char *agent_name;

  agent_name = getNetSolveAgent();
  if (agent_name == NULL)
  {
    ns_errno = NetSolveSetNetSolveAgent;
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    return;
  }
 
  status = netsolveInfo(s,&pd);
  free(agent_name);
  if (status == -1)
  {
    mexPrintf("%s\n",netsolveErrorMessage(ns_errno));
    return;
  }

  mexPrintf("-- %s --",pd->nickname);
  mexPrintf(pd->description);
  mexPrintf("* %d objects in INPUT\n",pd->nb_input_objects);
  for (i=0;i<pd->nb_input_objects;i++)
  {
    mexPrintf(" - input %d: ",i);
    mxDisplayObject(pd->input_objects[i]);
  }
  mexPrintf("* %d objects in OUTPUT\n",pd->nb_output_objects);
  for (i=0;i<pd->nb_output_objects;i++)
  {
    mexPrintf(" - output %d: ",i);
    mxDisplayObject(pd->output_objects[i]);
  }
  if (pd->nb_matlab_merge != 0)
  {
    mexPrintf("--------------------------------------\n");
    for (i=0;i<pd->nb_matlab_merge;i++)
    {
      mexPrintf("Output Objects %d and %d can be merged.\n", 
                     pd->matlab_merge[i].index1,pd->matlab_merge[i].index2);
    }
  }
  
  freeProblemDesc(pd);
  ns_errno = NetSolveOK;
  return;
}
