/*****************************************************************/
/*      mxdisplayobject.c                                        */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "mex.h"
#include "core.h"
#include "client.h"
#include "matlabclient.h"

/*
 * Displays the an object description
 */
void mxDisplayObject(NS_Object *obj)
{
  switch(obj->object_type)
  {
    case NETSOLVE_MATRIX:
      mexPrintf("Matrix ");
      break;  
    case NETSOLVE_SPARSEMATRIX:
      mexPrintf("Sparse Matrix ");
      break;  
    case NETSOLVE_VECTOR:
      mexPrintf("Vector ");
      break;  
    case NETSOLVE_SCALAR:
      mexPrintf("Scalar ");
      break;  
    case NETSOLVE_UPF:
      mexPrintf("Fortran/C Function in a file.");
      break;  
    case NETSOLVE_FILE:
      mexPrintf("File.");
      break;  
    case NETSOLVE_STRINGLIST:
      mexPrintf("String list.");
      break;  
    case NETSOLVE_PACKEDFILES:
      mexPrintf("Packed files.");
      break;  
    case NETSOLVE_STRING:
      mexPrintf("String.");
      break;  
    default:
      mexPrintf("???");
  }
  switch(obj->data_type)
  {
    case NETSOLVE_I:
      mexPrintf("Integer.\n");
      break;
    case NETSOLVE_S:
      mexPrintf("Single Precision Real.\n");
      break;
    case NETSOLVE_D:
      mexPrintf("Double Precision Real.\n");
      break;
    case NETSOLVE_C:
      mexPrintf("Single Precision Complex.\n");
      break;
    case NETSOLVE_Z:
      mexPrintf("Double Precision Complex.\n");
      break;
    case NETSOLVE_B:
      mexPrintf("Byte.\n");
      break; 
    case NETSOLVE_CHAR:
      if (obj->object_type == NETSOLVE_STRINGLIST)
        break;
      if (obj->object_type == NETSOLVE_PACKEDFILES)
        break;
      if (obj->object_type == NETSOLVE_FILE)
        break;
      if (obj->object_type == NETSOLVE_STRING)
        break;
      if (obj->object_type == NETSOLVE_UPF)
        break;
      mexPrintf("Character.\n");
      break;
    default:
      mexPrintf("???");
  }
  mexPrintf(obj->description);
  ns_errno = NetSolveOK;
  return;
}
