/*
 *  $Id: ns_utils.h,v 1.1.1.1 1999/04/09 19:19:22 nsadmin Exp $
 * 
 * 
 */

#ifndef __ns_utils_h
#define __ns_utils_h

#define NSM_LOGFILENAME "/tmp/ns_math.log"

#ifndef LOGLEVEL
#define LOGLEVEL 5
#endif

struct svr_descr {
   char		 *name;
   unsigned int  ip;
   int		 data_format;
   int		 Kflops;
   int		 host_status;
   int		 server_status;
   int		 n_processors;
   int		 MPP;
   int		 workload;
   int		 n_problems;
   
/* this is used to get the address of next byte
 * usefull if we like to store the name in the same memory block so 
 * that to able to free the block at once
 * 
 * i would put empty structure here, but some compilers do not like that
 */
   char          name_glue;
};

/* ns_list_problems() -- gets a lists of problems
 * 
 *   returns in 
 *     n      - the list size
 *     pblist - an array of pointers to strings containing the problem names
 * 
 *   Note: the list should be freed when it's no more needed via a call to free_ptr_array()
 */
char *ns_list_problems(int *n, char **pblist[]);


/* ns_list_servers() -- gets a list of description for the servers
 */
char *ns_list_servers(int *n, char  **slist[]);
 
void ns_sprintf_svr_descr(char *s, struct svr_descr *svr);


/* free_ptr_array() -- frees an array of allocated blocks
 *     n      - the number of array elements
 *     array  - an array of pointers to allocated blocks
 */
void free_ptr_array(int n, void **array);


char *netsolve_error(int );

void log(int watermark, char *fmt, ...);
void log_and_printf_msg(int lvl, char *fmt, ...);
void nsmath_initlog();
void nsmath_msg(char *msg);
void nsmath_printf_msg(char *fmt, ...);
void nsmath_return_null();

#endif
  
   
   
   
