/*
 *  $Id: ns_utils.c,v 1.1.1.1 1999/04/09 19:19:22 nsadmin Exp $
 * 
 */ 


#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <assert.h>

#include "mathlink.h"

#include "core.h"
#include "netsolveerror.h"
#include "client.h"


#include "ns_utils.h"
#include "nsmath.h"

FILE *nsmath_log = NULL;

char* netsolve_error(int status)

{
   return netsolveErrorMessage(status);
}

int cmp_str(const void *s1, const void *s2)
{
   return strcmp(*((char **) s1), *((char **) s2));
}


void freeProblemDescList(int n, ProblemDesc **list)
{
   int i;
   
   for(i=0; i<n; i++)
     freeProblemDesc(list[i]);
}

void freeAgentDescList(int n, AgentDesc **list)
{
   int i;
   
   for(i=0; i<n; i++)
     freeAgentDesc(list[i]);
}

void freeServerDescList(int n, ServerDesc **list)
{
   int i;
   
   for(i=0; i<n; i++)
     freeServerDesc(list[i]);
}

/*  ns_list_problems 
 * 
 */
char *ns_list_problems(int *npb, char **desc_list[])
{
   char         **list;
   ProblemDesc  **pblist;
   int 		n, i;

   if (!npb || !desc_list) 
     return netsolve_error(ns_errno = NetSolveBadValues);
  

   ns_errno = *npb = n = getAllProblems(&pblist);
   if (n < 0) *npb = -1;
   if (n <=0) return NULL;

   list = calloc(n, sizeof(char *));
   for(i=0; i<n; i++) 
     list[i] = strdup(pblist[i]->name);

   freeProblemDescList(n, pblist);
   qsort(list, n, sizeof(char *), cmp_str);
   
   *desc_list = list;
   ns_errno = NetSolveOK;
   return NULL;   
}

int cmp_svr_byname(const void *s1, const void *s2)
{
   return strcmp((*((struct svr_descr **) s1))->name,(*((struct svr_descr **) s2))->name);
}

char *ns_server_descr(ServerDesc *svr)
{
   char 	*h_status;
   HostDesc 	*hd;
   char 	buf[256];
   
   if (!svr) return NULL;
   
   hd = svr->host_desc;
   h_status = (hd->host_status) ? "Up" : "Down";
   
   sprintf(buf, "%s (%u.%u.%u.%u)\tHost: %s",
	   hd->hostname, BYTE(&hd->IPaddr, 0), BYTE(&hd->IPaddr, 1), 
	   BYTE(&hd->IPaddr, 2), BYTE(&hd->IPaddr, 3),
	   h_status);
   return strdup(buf);
}

char *ns_agent_descr(AgentDesc *svr)
{
   char 	*h_status;
   HostDesc 	*hd;
   char 	buf[256];
   
   if (!svr) return NULL;
   
   hd = svr->host_desc;
   h_status = (hd->host_status) ? "Up" : "Down";
   
   sprintf(buf, "%s (%u.%u.%u.%u)\tHost: %s",
	   hd->hostname, BYTE(&hd->IPaddr, 0), BYTE(&hd->IPaddr, 1),
	   BYTE(&hd->IPaddr, 2), BYTE(&hd->IPaddr, 3),
	   h_status);
   return strdup(buf);
}

/*  ns_list_servers
 * 
 */
char *ns_list_servers(int *nlist, char **desc_list[])
{
   ServerDesc 	**svrlist;
   AgentDesc	**agentlist;
   char         **list;
   int		i, ns, na;
   
   if (!nlist || !desc_list) 
     return netsolve_error(ns_errno = NetSolveBadValues);

   ns  = getAllServers(&svrlist);
   if (ns <  0) *nlist = -1;
   if (ns <= 0) return NULL;

   na  = getAllAgents(&agentlist);
   if (na <  0) *nlist = -1;
   if (na <= 0) {
      freeServerDescList(ns, svrlist);
      return NULL;
   }

   list = (char **) calloc(na+ns+2, sizeof(char *));
   list[0] = strdup("---- List of NetSolve agents ----");
   for(i=0; i<na; i++) {
      log(1, "agent %d", i);
      list[i+1] = ns_agent_descr(agentlist[i]);
   }

   qsort(&list[1], na, sizeof(char *), cmp_str);
   freeAgentDescList(na, agentlist);

   list[na+1] = strdup("---- List of NetSolve servers ----");
   for(i=0; i<ns; i++) {
      log(1, "server %d", i);
      list[na+i+2] = ns_server_descr(svrlist[i]);
   }
   log(1, "p2");
   qsort(&list[na+2], ns, sizeof(char *), cmp_str);
   log(1, "p22, na = %d, ns = %d", na , ns);
   freeServerDescList(ns, svrlist);

   log(1, "p3");
   *nlist = na + ns + 2;
   *desc_list = list;
   ns_errno = NetSolveOK;

   return NULL;   
}

void free_ptr_array(int n, void  **array)
{
   int i;

   for(i=0; i<n; i++)
     free(array[i]);
}

void log(int watermark, char *fmt, ...)
{
   va_list arg;
 
   if (!nsmath_log || watermark > LOGLEVEL) return;
   
   va_start(arg, fmt);
   vfprintf(nsmath_log, fmt, arg);
   va_end(arg);
   
   fprintf(nsmath_log, "\n");
   fflush(nsmath_log);
}


void log_and_printf_msg(int lvl, char *fmt, ...)
{
/* FIXME: BADSTYLE: */   
   char junk[256];
   
   va_list arg;
   
   va_start(arg, fmt);

   vsprintf(junk, fmt, arg);
   va_end(arg);
   
     
   log(lvl, junk);
   nsmath_msg(junk);
}


void nsmath_initlog()
{
   if (nsmath_log) return;
   nsmath_log = fopen(NSM_LOGFILENAME, "a+");
   if (nsmath_log) 
     fprintf(nsmath_log, "------ new session started ------\n");
}

#if MLVERSION < 3
#define MLEVALUATE(mlp, s) MLEvaluate(mlp, s)
#else
#define MLEVALUATE(mlp, s) MLEvaluatev3(mlp, s)
int MLEvaluatev3(MLINK mlp, char *s)
{
   if (MLAbort) return 0;
   return MLPutFunction(mlp, "EvaluatePacket", 1L)
     && MLPutFunction(mlp, "ToExpression", 1L)
       && MLPutByteString(mlp, s, strlen(s))
	 && MLEndPacket(mlp);
}
#endif

void nsmath_msg(char *msg)
{
   char *fmt = "Print[\"%s\"]";
   char *submsg, *s, *buf, *buf2;

   buf = (char *) malloc(strlen(fmt)+strlen(msg)+1);
   buf2= (char *) malloc(strlen(fmt)+strlen(msg)+1);
   submsg = msg;
   do {
      s = strchr(submsg, '\n');
      if (s) {
	 strncpy(buf, submsg, s-submsg);
	 buf[s-submsg] = '\0';
	 s++;
      }
      else strcpy(buf, submsg);

      sprintf(buf2, fmt, buf);
      log(9, "nsmath_msg: %s", buf2);
 
 /*   MLNewPacket(stdlink); */
      MLEVALUATE(stdlink, buf2);
      if (MLNextPacket(stdlink) == RETURNPKT)
        MLNewPacket(stdlink);        
      
      submsg = s;
   } while (submsg);
   
   free(buf);
   free(buf2);
   return;
}

void nsmath_printf_msg(char *fmt, ...)
{
/* BADSTYLE -- 
 *   I don't like fixed size buffers if I am not sure about max size of the contents */
   
   char 	junk[512];
   va_list 	arg;
 
   va_start(arg, fmt);
   vsprintf(junk, fmt, arg);

   if (strlen(junk) >= sizeof(junk)) {
      log(1, "FATAL ERROR in file %s, line %s: buffer overrun", __FILE__, __LINE__);
      assert(strlen(junk) >= sizeof(junk));
   }
   va_end(arg);
   nsmath_msg(junk);
}

void nsmath_return_null()
{
   log(1, "nsmath_return_null called()");
   MLPutSymbol(stdlink, "Null");
}

