#include "core.h"
#include "client.h"
#include "netsolveerror.h"

#include <stdlib.h>

#define M 4
#define N 4

void print_complex_vector(char *msg, double *a, int n)
{
   int i;
   
   printf(msg);
   for(i=0; i<n; i++)
     printf("%7.3lf%+.3lfi%s", a[2*i], a[2*i+1], (i==n-1) ? "\n" : "   ");
}

void gen_rand_double_matrix(int m, int n, double *a)
{
   int i,j;
   
   for(i=0; i<m; i++) 
     for(j=0; j<n; j++)
       a[i*n + j] = (rand() % 100) / 10.0;
}

void mul(int m, int n, int k, double *a, double *b, double *c)
{
   int i,j,l;
   
   for(i=0; i<m; i++)
     for(j=0; j<k; j++) {
	c[i*m+j] = 0;
	for(l=0; l<n; l++)
	  c[i*m + j] += a[i*n + l] * b[l*k+j];
     }
}

main(int argc,char **argv)
{
   int status, i, j;
   double x[2*N], y[2*N], z[2*N], alpha[2];

   
   printf("This demo calculates z = a*x + y\n");
   printf("where x and y are complex vectors.\n\n");
   
   
   gen_rand_double_matrix(1,2, alpha);
   gen_rand_double_matrix(1,2*N, x);
   gen_rand_double_matrix(1,2*N, y);
   
   print_complex_vector("alpha is:\n", alpha, 1);
   print_complex_vector("Vectot x is:\n", x, N);
   print_complex_vector("Vector y is:\n", y, N);
   printf("\n");

   i = 1;
   status = netsl("zaxpy()", N, alpha, x, &i, y, &i);

   if (status != NetSolveOK) {
      netsolveDisplayError(status);
      exit(0);
   }
   
   print_complex_vector("The result is:\n", y, N);
}
