#include "core.h"
#include "client.h"
#include "netsolveerror.h"

#include <stdlib.h>

#define N 10

void print_vector(char *msg, int v[], int n)
{
   int i;
   
   printf(msg);
   for(i=0; i<n; i++) 
      printf("%d%s", v[i], (i==n-1) ? "\n" : ", ");
}

main(int argc,char **argv)
{
   int status, i;
   int v[N], v_sorted[N];

   for(i=0; i<N; i++)
     v[i] = rand() % 100;
   
   
   print_vector("Vector to be sorted is:\n", v, N);
   printf("\n");
   
   status = netsl("iqsort()", N, v, v_sorted);

   if (status != NetSolveOK) {
      netsolveDisplayError(status);
      exit(0);
   }
   
   print_vector("Sorted vector:\n", v_sorted, N);
}
