/*
 * 
 *   $Id: ktest.c,v 1.2 2001/07/12 14:07:35 shi Exp $
 * 
 */

#include <stdio.h>
#include<stdlib.h>     /* for getenv() */
#include <string.h>
#include "mathlink.h"

int line = 0;

int argc = 4;
char *argv[5] = {"-linkname", "$MATH -mathlink", "-linkmode", 
                 "launch", NULL};

char *getcmd(char *s)
{
   printf("In[%d] := ", ++line);
   fflush(stdout);
   return gets(s);
}

int MLEvaluate(MLINK mlp, char *s)
{
   return MLPutFunction( mlp, "EvaluatePacket", 1L)
     && MLPutFunction(mlp, "ToString", 1L)
       && MLPutFunction( mlp, "ToExpression", 1L)
	 && MLPutString( mlp, s); 
}

void PrintResult(MLINK lp)
{
   int i;
   long len, wholelen;
   char buf[100];

   MLGetType(lp);
   while (MLBytesToGet(lp, &len), len > 0) {
      if (len > sizeof(buf)) len = sizeof(buf);
      MLGetData(lp, buf, len, &wholelen);
      for(i=0; i<len; i++) 
	printf("%c", buf[i]);
   }
}

int main()
{
/*   int i,j,sum; */
   
   MLINK lp;
 /*  int pkt; */
   MLEnvironment env;
   char buf[1024];
   
   env = MLInitialize(NULL);
   if (env == NULL) return 1;
   
   if (getenv("MATH")==NULL) 
      argv[1] = "math -mathlink";
   lp = MLOpen(argc, argv);
   if (lp == NULL) return 1;
   
   while (getcmd(buf) && strlen(buf)>0) {
      MLEvaluate(lp, buf);
      
      while (MLNextPacket(lp) != RETURNPKT) 
	MLNewPacket(lp);

      printf("Out[%d]= ", line);
      PrintResult(lp);
      printf("\n\n");
   }
   
   MLClose(lp);
   MLDeinitialize(env);
   
   return 0;
}
