#include "core.h"
#include "client.h"
#include "netsolveerror.h"

#include <stdlib.h>

#define N 10

void print_vector(char *msg, int v[], int n)
{
   int i;
   
   printf(msg);
   for(i=0; i<n; i++) 
      printf("%d%s", v[i], (i==n-1) ? "\n" : ", ");
}

main(int argc,char **argv)
{
   int status, i, rc;
   char buf[512], result_expr[512];

   printf("Please enter a valid Mathematica expression.\n");
   printf("Example:\n\tSolve[x^3 - 7 x^2 + 3 a x == 0, x]\n\n");
   printf("expression> ");
   fflush(stdout);
   gets(buf);
   
   printf("\n");
   
   status = netsl("math()", buf, result_expr, &rc);

   if (status != NetSolveOK) {
      netsolveDisplayError(status);
      exit(0);
   }
   
   if (rc != 0) 
     printf("\nmath() function returned a result code %d\n", rc);
   else 
     printf("\nThe result of calculation is:\n%s\n", result_expr);
}
