#include "core.h"
#include "client.h"
#include "netsolveerror.h"

#include <stdlib.h>

#define M 3
#define N 3

void print_double_matrix(char *msg, double *a, int m, int n)
{
   int i, j;
   
   printf(msg);
   for(i=0; i<m; i++)
     for(j=0; j<n; j++)
       printf("%7.3lf%s", a[i*n+j], (j==n-1) ? "\n" : "  ");
}

void gen_rand_double_matrix(int m, int n, double *a)
{
   int i,j;
   
   for(i=0; i<m; i++) 
     for(j=0; j<n; j++)
       a[i*n + j] = (rand() % 100) / 10.0;
}

void mul(int m, int n, int k, double *a, double *b, double *c)
{
   int i,j,l;
   
   for(i=0; i<m; i++)
     for(j=0; j<k; j++) {
	c[i*m+j] = 0;
	for(l=0; l<n; l++)
	  c[i*m + j] += a[i*n + l] * b[l*k+j];
     }
}

main(int argc,char **argv)
{
   int status, i, j;
   double a[M*N], b[M*N];

   
   printf("This demo solves A.x = B\n");
   
   gen_rand_double_matrix(M, N, a);
   
   for(i=0; i<M; i++) {
      b[i] = 0;
      for(j=0; j<N; j++)
	b[i] += a[i*N + j];
   }
     
   
   print_double_matrix("Matrix A is:\n", a, M, N);
   print_double_matrix("Matrix B is:\n", b, M, 1);
   printf("\n");

   status = netsl("linsol()", M, 1, a, M, b, M);

   if (status != NetSolveOK) {
      netsolveDisplayError(status);
      exit(0);
   }
   
   print_double_matrix("The solutions is:\n", b, M, 1);
}
