/*
 *   $Id: CalcMathExpr.c,v 1.1.1.1 1999/04/09 19:19:18 nsadmin Exp $
 * 
 */

#include <stdlib.h>
#include <string.h>

#include "mathlink.h"


 FILE *f;

int MLEvaluate(MLINK mlp, char *s)
{
   return MLPutFunction( mlp, "EvaluatePacket", 1L)
     && MLPutFunction(mlp, "ToString", 1L)
       && MLPutFunction( mlp, "ToExpression", 1L)
	 && MLPutString( mlp, s); 
}

char *GetResult(MLINK lp)
{
   long len, wholelen;
   char *buf;

   MLGetType(lp);
   MLBytesToGet(lp, &len);
   
   fprintf(f, "GetResult()\n");
   fprintf(f, "bytes to get %ld\n", len);

   buf = malloc(len+1);
   if (!buf) return NULL;
   buf[len] = 0;
   
   MLGetData(lp, buf, len, &wholelen);
   return buf;
}

char *CalcMathExpr(char *expr, int *rc)
{
   MLINK 	 lp;
   MLEnvironment env;
   char 	 *result;
   int argc = 4;
   char cmd_line[64];
   char *argv[5] = {"-linkname", "$MATH -mathlink", "-linkmode", 
                    "launch", NULL};

   f = fopen("/tmp/srv_math2.log", "w");
   
   fprintf(f, "CalcMathExpr()\n");
   fflush(f);
   
   if (!expr) return NULL;
   
   env = MLInitialize(NULL);
   *rc = env == NULL;
   if (*rc) return NULL;
   
   
   if (getenv("MATH")==NULL) 
      argv[1] = "math -mathlink";
   else {
      sprintf(cmd_line, "%s -mathlink", getenv("MATH"));
      argv[1] = cmd_line;
   }
     
   
   lp = MLOpen(argc, argv);
   *rc = lp == NULL;
   if (*rc) return NULL;
   
   fprintf(f, "ML link established\n");
   fprintf(f, "the expression is: %s\n", expr);
   fflush(f);
   MLEvaluate(lp, expr);
      
   while (MLNextPacket(lp) != RETURNPKT) 
     MLNewPacket(lp);

   result = GetResult(lp);

   MLClose(lp);
   MLDeinitialize(env);
   
   fprintf(f, "The result is: %s\n", result);
   fclose(f);
   return result;
}
