#include "mcelldriver.h"
#include "core.h"
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

/*
 * isOriginalScript()
 */
int isOriginalScript(char *filename)
{
  FILE *f;
  char line[256];

  f = fopen(filename,"r");
  if (f == NULL)  
  {
    fprintf(stderr,"Impossible to open '%s'\n",filename);
    return 1;
  }

  if (fgets(line,256,f) == NULL)
  {
    fprintf(stderr,"Read error on file '%s'\n",filename);
    fclose(f);
    return 1; 
  }
  fclose(f);

  if (!strncmp(line,"------- MCell",13))
    return 0;
  else
    return 1;
}

/*
 * saveParseFile()
 */
void saveParseFile(char *script,int nb_comps, NS_MCellComputationDesc **comps)
{
  char parsefilename[256];
  FILE *parsefile;
  int i,j;

  sprintf(parsefilename,"%s.parse",script);
  fprintf(stderr,"Saving parse infomation to '%s'\n",parsefilename);
  
  parsefile = fopen(parsefilename,"w");
  if (parsefile == NULL)
  {
    fprintf(stderr,"Impossible to open file '%s' fo creation\n",parsefilename);
    return;
  }
  
  fprintf(parsefile,"------- MCell Parse file for: %s -------\n",script);
  fprintf(parsefile,"%d\n",nb_comps);
  for (i=0;i<nb_comps;i++)
  {
    fprintf(parsefile,"%s %d %d\n",comps[i]->mdlfile,
                                   comps[i]->seed,
                                   comps[i]->iterations);
    fprintf(parsefile,"%d\n",comps[i]->nb_includefiles);
    for (j=0;j<comps[i]->nb_includefiles;j++)
      fprintf(parsefile,"%s\n",comps[i]->includefiles[j]);
    fprintf(parsefile,"%d\n",comps[i]->nb_outputfiles);
    for (j=0;j<comps[i]->nb_outputfiles;j++)
      fprintf(parsefile,"%s\n",comps[i]->outputfiles[j]);
    fprintf(parsefile,"-------------\n");
  }
  fclose(parsefile);
  return; 
}

/*
 * loadParseFile()
 */
NS_MCellComputationDesc **loadParseFile(char *parsefilename, int *nb_comps)
{
  FILE *f;
  char line[256];
  int i,j;
  int nb;
  NS_MCellComputationDesc **new = NULL;
  
  f = fopen(parsefilename,"r");
  if (f == NULL)
  {
    fprintf(stderr,"Impossible to open file '%s'\n",parsefilename);
    return NULL;
  }
  if (fgets(line,256,f) == NULL)
  {
    fprintf(stderr,"Read error on file '%s'\n",parsefilename);
    fclose(f);
    return NULL;
  }
  if (line[0] != '-')
  {
    fprintf(stderr,"File '%s' not a parse file\n",parsefilename);
    fclose(f);
    return NULL;
  }
  if (fgets(line,256,f) == NULL)
  {
    fprintf(stderr,"Read error on file '%s'\n",parsefilename);
    fclose(f);
    return NULL;
  }

  if (sscanf(line,"%d\n",&nb) != 1)
  {
    fprintf(stderr,"File '%s' corrupted\n",parsefilename);
    fclose(f);
    return NULL;
  }

  *nb_comps = nb;
  new = (NS_MCellComputationDesc **)calloc(nb,sizeof(NS_MCellComputationDesc*));

  for (i=0;i<nb;i++)
  {
    int seed,iterations;
    char mdlfile[256];
    int nbinput,nboutput;

    if (fgets(line,256,f) == NULL)
    {
      fprintf(stderr,"Read error on file '%s'\n",parsefilename);
      fclose(f);
      return NULL;
    }
    if (sscanf(line,"%s %d %d\n",mdlfile,&seed,&iterations) != 3)
    {
      fprintf(stderr,"File '%s' corrupted\n",parsefilename);
      fclose(f);
      return NULL;
    }
    new[i] = (NS_MCellComputationDesc *)calloc(1,sizeof(NS_MCellComputationDesc));
    new[i]->mdlfile = strdup(mdlfile);
    new[i]->seed = seed;
    new[i]->iterations = iterations;
    if (fgets(line,256,f) == NULL)
    {
      fprintf(stderr,"Read error on file '%s'\n",parsefilename);
      fclose(f);
      return NULL;
    }
    if (sscanf(line,"%d\n",&nbinput) != 1)
    {
      fprintf(stderr,"Read error on file '%s'\n",parsefilename);
      fclose(f);
      return NULL;
    }
    new[i]->nb_includefiles = nbinput;
    new[i]->includefiles = (char **)calloc(nbinput,sizeof(char*));
    for (j=0;j<nbinput;j++)
    {
      if (fgets(line,256,f) == NULL)
      {
        fprintf(stderr,"Read error on file '%s'\n",parsefilename);
        fclose(f);
        return NULL;
      }
      line[strlen(line)-1] = '\0';
      (new[i]->includefiles)[j] = strdup(line);
    }
    if (fgets(line,256,f) == NULL)
    {
      fprintf(stderr,"Read error on file '%s'\n",parsefilename);
      fclose(f);
      return NULL;
    }
    if (sscanf(line,"%d\n",&nboutput) != 1)
    {
      fprintf(stderr,"Read error on file '%s'\n",parsefilename);
      fclose(f);
      return NULL;
    }
    new[i]->nb_outputfiles = nboutput;
    new[i]->outputfiles = (char **)calloc(nboutput,sizeof(char*));
    for (j=0;j<nboutput;j++)
    {
      if (fgets(line,256,f) == NULL)
      {
        fprintf(stderr,"Read error on file '%s'\n",parsefilename);
        fclose(f);
        return NULL;
      }
      line[strlen(line)-1] = '\0';
      (new[i]->outputfiles)[j] = strdup(line);
    }
    if (fgets(line,256,f) == NULL)
    {
      fprintf(stderr,"Read error on file '%s'\n",parsefilename);
      fclose(f);
      return NULL;
    }
    if (line[0] != '-')
    {
      fprintf(stderr,"File '%s' corrupted\n",parsefilename);
      fclose(f);
      return NULL;
    }
  }

  fclose(f);
  return new;
}
