#include <stdio.h>
#include "mcelldriver.h"
#include <strings.h>
#include <stdlib.h>
#include <unistd.h>

/*
 * fillInNetSolveData()
 */
int fillInNetSolveData(int nb_comps, NS_MCellComputationDesc **comps,
                       char *script,
                       char ***I0, char ***I1,
                       int *mI0, char ***I2, int*mI2,
                       int **I3, int **I4,
                       char **O0, char **O1, char **O2)
{
  int i,j;
  int nb;
  NS_MCellComputationDesc *current;
  char buffer[256];

  for (i=0;i<nb_comps;i++)
  {
    current = comps[i];

    /* Generate the list of input filenames and files */
    nb = current->nb_includefiles;
    I0[i] = (char **)calloc(nb,sizeof(char*));
    I1[i] = (char **)calloc(nb,sizeof(char*));
    for (j=0;j<nb;j++)
    {
      I0[i][j] = strdup(current->includefiles[j]);
      I1[i][j] = strdup(current->includefiles[j]);
    }
    mI0[i] = nb;

    /* Generate the list of output filenames */
    nb = current->nb_outputfiles; 
    I2[i] = (char **)calloc(nb,sizeof(char*));
    for (j=0;j<nb;j++)
      I2[i][j] = strdup(current->outputfiles[j]);
    mI2[i] = nb;
    /* Generate the seed */
    I3[i] = (int *)calloc(1,sizeof(int));
    I3[i][0] = current->seed;
    /* Generate the iterations */
    I4[i] = (int *)calloc(1,sizeof(int));
    I4[i][0] = current->iterations;
    /* Generate the output packed file */
    sprintf(buffer,"tmp.%s.%d",script,getpid());
/*
    O0[i] = strdup(buffer);
*/
    O0[i] = NULL;
    /* Generate the stdout file */
    sprintf(buffer,"%s.stdout.%d",script,i);
    O1[i] = strdup(buffer);
    sprintf(buffer,"%s.stderr.%d",script,i);
    O2[i] = strdup(buffer);
  }
  return 1;
}
                       
/*
 * freeNetSolveData()
 */
void freeNetSolveData( int nb_comps, char ***I0, char ***I1,
                       int *mI0, char ***I2, int *mI2,
                       int **I3, int **I4,
                       char **O0, char **O1, char **O2)
{
  int i,j;

  for (i=0;i<nb_comps;i++)
  {
    for (j=0;j<mI0[i];j++)
    {
      free(I0[i][j]);
      free(I1[i][j]);
    }
    free(I0[i]);
    free(I1[i]);
    for (j=0;j<mI2[i];j++)
      free(I2[i][j]);
    free(I2[i]);
    free(I3[i]);
    free(I4[i]);
    free(O0[i]);
    free(O1[i]); 
    free(O2[i]); 
  }
  free(I0); free(I1); free(mI0); free(I2);
  free(mI2); free(I3); free(I4); free(O0); free(O1); free(O2);
}





