/*****************************************************************/
/*      startlifelink.c                                          */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "netsolvesignals.h"
#include "lifelink.h"
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <signal.h>
#include <unistd.h>

/*
 * start the LifeLink
 *
 * This calls creates a process that maintains a bogus socket connection
 * to the calling proces and reports connection shutdown to a
 * given port and IPaddr, with a given tag and 2 int messages.
 */
int startLifeLink(NS_IPaddr_type IPaddr_to_contact, int port_to_contact, 
                  int tag, int message1,int message2) 
{
  NS_Socket_type bogus_sock,sock;
  int bogus_port;
  int pid;
  void lifelink_handler(int);

  bogus_sock = bindToFirstAvailablePort(PORT_INIT,&bogus_port);
  if (bogus_sock == -1)
  {
    netsolvePerror("bindToFirstAvailablePort()");
    return -1;
  }

  pid = fork();
  if (pid == -1)
  {
    ns_errno = NetSolveSystemError;
    ns_printinfo();
    perror("fork()");
    return -1;
  }
 
  if (pid)
  {              /* FATHER */
    listen(bogus_sock,MAX_CONNECTIONS);
    while(1)
    {
      sock = acceptConnection(bogus_sock);
      if (sock == -1)
      {
        ns_printinfo();
        fprintf(stderr,"Warning -- acceptConnection returned -1 \n");
        continue; 
      }
      return pid;
    }
  }
  else
  {             /* CHILD */
    NS_Communicator *comm;
    int i;

    close(bogus_sock);
    sleep(1);
    signal(SIGINT,lifelink_handler);
    signal(SIGTERM,lifelink_handler);
    signal(SIGKILL,lifelink_handler);  /* (jakob) XXX: Why ? cannot handle SIGKILL anyway */

    for (i=0;i<10;i++)
    {
      sock = connectToSocket(NULL,getMyIPaddr(),bogus_port);
      if (sock != -1)
        break;
      sleep(1);
    }
    if (i == 10)
      exit(0);

    while(1)
    {
      if (isThereSomethingOnTheSocket(sock) == 0)
      {
         comm = contactHost(NULL,IPaddr_to_contact,port_to_contact,DATA_XDR);
         if (comm == NULL)
         {
           close(sock);
           exit(0);
         }
         sendInt(comm,tag);
         sendInt(comm,message1);
         sendInt(comm,message2);
         endTransaction(comm);
         exit(0);
      }
      sleep(5);
    }
  }
  return pid;
}

/*
 * Bogus handler
 */
void lifelink_handler(int sig)
{
}
