/*****************************************************************/
/*      iserv_refmon.c                                           */
/*      Jakob Oestergaard                                        */
/*---------------------------------------------------------------*/
/*  A Reference Monitor Implementation for the NS IS             */
/*****************************************************************/

#include "infoserver_int.h"

/*
 * Notes:
 *
 * Currently the reference monitor will return OK for all
 * operations.
 *
 * Once a security policy has been decided upon, it should
 * be trivial to integrate into the InfoServer, using the
 * reference monitor skeleton provided here.
 */

/*
 * refmon_grant() returns 0 on denial and 1 on accept.
 *
 * The <op> argument specifies the operation to be
 * considered.
 *
 * The <rec> argument holds the object (record) that is being
 * considered for the <op> operation to <peer>
 *
 * The <peer> argument is a combined subject and channel description,
 * it should identify both the subject and the communications channel
 * to/via which the object <rec> given will be <op>'ed 
 */

int refmon_grant(NS_IS_RM_Operation_t op, NS_IS_Record * rec, NS_IS_ClientConnection * peer)
{
  return 1;
}
